/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.n4idl;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.MigrationContextVariable;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4idl.versioning.MigrationUtils;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class N4IDLMigrationTransformation
extends Transformation {
    public void transform() {
        Functions.Function1 _function = m -> MigrationUtils.isMigrationDefinition((FunctionDefinition)m);
        Consumer<FunctionDeclaration> _function_1 = m -> this.transformMigrationDeclaration((FunctionDeclaration)m);
        IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)this.getState().im, FunctionDeclaration.class), (Functions.Function1)_function).forEach(_function_1);
    }

    private void transformMigrationDeclaration(FunctionDeclaration migrationDeclaration) {
        Consumer<IdentifierRef_IM> _function = identifier -> this.transformIdentifierReference((IdentifierRef_IM)identifier);
        EcoreUtil2.getAllContentsOfType((EObject)migrationDeclaration, IdentifierRef_IM.class).forEach(_function);
        Consumer<ParameterizedCallExpression> _function_1 = callExpr -> this.transformCallExpression(this.findTMigration(migrationDeclaration), (ParameterizedCallExpression)callExpr);
        EcoreUtil2.getAllContentsOfType((EObject)migrationDeclaration, ParameterizedCallExpression.class).forEach(_function_1);
    }

    private TMigration findTMigration(FunctionDeclaration migrationDeclaration) {
        boolean _not;
        SymbolTableEntry declarationSTE = (SymbolTableEntry)this.getState().steCache.mapNamedElement_2_STE.get(migrationDeclaration);
        if (!(declarationSTE instanceof SymbolTableEntryOriginal)) {
            throw new IllegalStateException("Failed to obtain SymbolTableEntryOriginal for migration declaration " + migrationDeclaration);
        }
        IdentifiableElement _originalTarget = ((SymbolTableEntryOriginal)declarationSTE).getOriginalTarget();
        boolean bl = _not = !(_originalTarget instanceof TMigration);
        if (_not) {
            throw new IllegalStateException("Encountered malformed migration declaration in transpiler: " + migrationDeclaration);
        }
        IdentifiableElement _originalTarget_1 = ((SymbolTableEntryOriginal)declarationSTE).getOriginalTarget();
        return (TMigration)_originalTarget_1;
    }

    private void transformIdentifierReference(IdentifierRef_IM ref) {
        SymbolTableEntry refSTE = ref.getId_IM();
        if (refSTE instanceof SymbolTableEntryOriginal && ((SymbolTableEntryOriginal)refSTE).getOriginalTarget() instanceof MigrationContextVariable) {
            SymbolTableEntryInternal contextSTE = this.getSymbolTableEntryInternal("context", true);
            ParameterizedPropertyAccessExpression_IM contextAccess = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{contextSTE});
            this.replace((Expression)ref, (Expression)contextAccess);
        }
    }

    private void transformCallExpression(TMigration contextMigration, ParameterizedCallExpression callExpression) {
        boolean _isMigrateCall = MigrationUtils.isMigrateCall((EObject)callExpression);
        if (_isMigrateCall) {
            this.transformMigrateCallExpression(contextMigration, callExpression);
        } else {
            boolean _refersToMigration_1;
            boolean _refersToMigration;
            Expression callTarget = callExpression.getTarget();
            if (callTarget instanceof ParameterizedPropertyAccessExpression_IM && (_refersToMigration = this.refersToMigration(((ParameterizedPropertyAccessExpression_IM)callTarget).getRewiredTarget()))) {
                this.transformExplicitMigrationCallExpression(contextMigration, callExpression);
            }
            if (callTarget instanceof IdentifierRef_IM && (_refersToMigration_1 = this.refersToMigration(((IdentifierRef_IM)callTarget).getRewiredTarget()))) {
                this.transformExplicitMigrationCallExpression(contextMigration, callExpression);
            }
        }
    }

    private boolean refersToMigration(SymbolTableEntry ste) {
        if (ste instanceof SymbolTableEntryOriginal) {
            IdentifiableElement originalTarget = ((SymbolTableEntryOriginal)ste).getOriginalTarget();
            return originalTarget instanceof TMigration;
        }
        return false;
    }

    private void transformMigrateCallExpression(TMigration contextMigration, ParameterizedCallExpression callExpression) {
        ParameterizedCallExpression transpiledCall = TranspilerBuilderBlocks._CallExpr();
        SymbolTableEntryInternal migrateSTE = this.getSymbolTableEntryInternal("migrate", true);
        transpiledCall.setTarget((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{migrateSTE}));
        Functions.Function1 _function = a -> TranspilerBuilderBlocks._ArrayElement((Expression)a.getExpression());
        Argument __Argument = TranspilerBuilderBlocks._Argument((Expression)TranspilerBuilderBlocks._ArrLit((ArrayElement[])((ArrayElement[])Conversions.unwrapArray((Object)ListExtensions.map((List)callExpression.getArguments(), (Functions.Function1)_function), ArrayElement.class))));
        transpiledCall.getArguments().addAll(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Argument[]{__Argument})));
        this.replace((Expression)callExpression, (Expression)transpiledCall);
    }

    private void transformExplicitMigrationCallExpression(TMigration contextMigration, ParameterizedCallExpression callExpression) {
        ParameterizedCallExpression transpiledCall = TranspilerBuilderBlocks._CallExpr();
        SymbolTableEntryInternal migrateWithSTE = this.getSymbolTableEntryInternal("migrateWith", true);
        transpiledCall.setTarget((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{migrateWithSTE}));
        Argument __Argument = TranspilerBuilderBlocks._Argument((Expression)callExpression.getTarget());
        Functions.Function1 _function = a -> TranspilerBuilderBlocks._ArrayElement((Expression)a.getExpression());
        Argument __Argument_1 = TranspilerBuilderBlocks._Argument((Expression)TranspilerBuilderBlocks._ArrLit((ArrayElement[])((ArrayElement[])Conversions.unwrapArray((Object)ListExtensions.map((List)callExpression.getArguments(), (Functions.Function1)_function), ArrayElement.class))));
        transpiledCall.getArguments().addAll(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Argument[]{__Argument, __Argument_1})));
        this.replace((Expression)callExpression, (Expression)transpiledCall);
    }

    public void analyze() {
    }

    public void assertPostConditions() {
    }

    public void assertPreConditions() {
    }
}

