/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import org.apache.log4j.Logger;

public abstract class EnvironmentVariableUtils {
    private static final Logger LOGGER = Logger.getLogger(EnvironmentVariableUtils.class);
    private static final String NODEJS_PATH_ENV = "NODEJS_PATH";

    public static ProcessBuilder inheritNodeJsPathEnvVariableUtils(ProcessBuilder pb) {
        if (pb != null) {
            String nodeJsPath = System.getenv(NODEJS_PATH_ENV);
            if (nodeJsPath == null || nodeJsPath.trim().length() == 0) {
                EnvironmentVariableUtils.info("No NODEJS_PATH environment variable was specified. Nothing to merge.");
            } else if (!pb.environment().containsKey(NODEJS_PATH_ENV)) {
                EnvironmentVariableUtils.info("Setting NODEJS_PATH environment variable to process builder.");
                pb.environment().put(NODEJS_PATH_ENV, nodeJsPath);
            } else {
                EnvironmentVariableUtils.info("Process builder already has NODEJS_PATH environment variable with value: " + pb.environment().get(NODEJS_PATH_ENV) + ". Nothing to do.");
            }
        }
        return pb;
    }

    private static void info(Object message) {
        LOGGER.info(message);
        System.out.println(message);
    }
}

