/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.classifiers;

import com.google.common.base.Predicate;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.n4js.ui.dialog.ModuleSpecifierSelectionDialog;
import org.eclipse.n4js.ui.wizard.classifiers.N4JSClassifierWizardModel;
import org.eclipse.n4js.ui.wizard.components.AccessModifierComponent;
import org.eclipse.n4js.ui.wizard.components.NameComponent;
import org.eclipse.n4js.ui.wizard.components.OtherClassifierModifiersComponent;
import org.eclipse.n4js.ui.wizard.components.WizardComponentDataConverters;
import org.eclipse.n4js.ui.wizard.generator.ContentBlock;
import org.eclipse.n4js.ui.wizard.generator.WorkspaceWizardGenerator;
import org.eclipse.n4js.ui.wizard.model.AccessModifier;
import org.eclipse.n4js.ui.wizard.model.DefinitionFileModel;
import org.eclipse.n4js.ui.wizard.workspace.PreviewableWizardPage;
import org.eclipse.n4js.ui.wizard.workspace.SuffixText;
import org.eclipse.n4js.ui.wizard.workspace.WizardPreviewProvider;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModel;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModelValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class N4JSNewClassifierWizardPage<M extends N4JSClassifierWizardModel>
extends PreviewableWizardPage<M> {
    protected NameComponent nameComponent;
    protected AccessModifierComponent accessModifierComponent;
    protected OtherClassifierModifiersComponent otherClassifierModifiersComponent;

    @Override
    public void openModuleSpecifierDialog(Shell shell) {
        ModuleSpecifierSelectionDialog dialog = new ModuleSpecifierSelectionDialog(shell, ((N4JSClassifierWizardModel)this.getModel()).getProject().append(((N4JSClassifierWizardModel)this.getModel()).getSourceFolder()));
        if (!((N4JSClassifierWizardModel)this.getModel()).getEffectiveModuleSpecifier().isEmpty()) {
            String initialSelectionSpecifier = ((N4JSClassifierWizardModel)this.getModel()).getEffectiveModuleSpecifier();
            String fileExtension = ((N4JSClassifierWizardModel)this.getModel()).computeFileLocation().getFileExtension();
            if (fileExtension != null) {
                dialog.setDefaultFileExtension(fileExtension);
            }
            dialog.setInitialSelection(initialSelectionSpecifier);
        }
        dialog.open();
        Object result = dialog.getFirstResult();
        if (result instanceof String) {
            Path specifierPath = new Path((String)result);
            String fileExtension = specifierPath.getFileExtension();
            if (fileExtension != null && !fileExtension.isEmpty()) {
                if (fileExtension.equals("n4jsd") != ((N4JSClassifierWizardModel)this.getModel()).isDefinitionFile()) {
                    ((N4JSClassifierWizardModel)this.getModel()).setDefinitionFile(!((N4JSClassifierWizardModel)this.getModel()).isDefinitionFile());
                }
                specifierPath = specifierPath.removeFileExtension();
            }
            if (specifierPath.segmentCount() > 0 && specifierPath.removeFileExtension().lastSegment().equals(((N4JSClassifierWizardModel)this.getModel()).getName()) && !((N4JSClassifierWizardModel)this.getModel()).getName().isEmpty()) {
                specifierPath = specifierPath.segmentCount() > 1 ? specifierPath.removeLastSegments(1).addTrailingSeparator() : specifierPath.removeLastSegments(1);
            }
            ((N4JSClassifierWizardModel)this.getModel()).setModuleSpecifier(specifierPath.toString());
        }
    }

    protected void setupBindings() {
        DataBindingContext dataBindingContext = this.getDataBindingContext();
        IObservableValue moduleSpecifierValue = BeanProperties.value(WorkspaceWizardModel.class, (String)"moduleSpecifier", String.class).observe(this.getModel());
        IObservableValue suffixVisibilityValue = BeanProperties.value(SuffixText.class, (String)"suffixVisible", Boolean.class).observe((Object)this.workspaceWizardControl.getModuleSpecifierText());
        dataBindingContext.bindValue(suffixVisibilityValue, moduleSpecifierValue, N4JSNewClassifierWizardPage.noUpdateValueStrategy(), WizardComponentDataConverters.strategyForPredicate((Predicate<Object>)((Predicate)m -> {
            String moduleSpecifier = (String)m;
            return moduleSpecifier.isEmpty() || moduleSpecifier.charAt(moduleSpecifier.length() - 1) == '/';
        })));
        IObservableValue interfaceNameModelValue = BeanProperties.value(N4JSClassifierWizardModel.class, (String)"name", String.class).observe((Object)((N4JSClassifierWizardModel)this.getModel()));
        IObservableValue greySuffixValue = BeanProperties.value(SuffixText.class, (String)"suffix", String.class).observe((Object)this.workspaceWizardControl.getModuleSpecifierText());
        dataBindingContext.bindValue(greySuffixValue, interfaceNameModelValue, N4JSNewClassifierWizardPage.noUpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        IObservableValue externalValue = BeanProperties.value(DefinitionFileModel.class, (String)"definitionFile", Boolean.class).observe((Object)((DefinitionFileModel)this.getModel()));
        ISWTObservableValue n4jsEnabled = WidgetProperties.enabled().observe((Widget)this.otherClassifierModifiersComponent.getN4jsAnnotationBox());
        dataBindingContext.bindValue((IObservableValue)n4jsEnabled, externalValue, N4JSNewClassifierWizardPage.noUpdateValueStrategy(), WizardComponentDataConverters.strategyForPredicate((Predicate<Object>)((Predicate)input -> ((N4JSClassifierWizardModel)this.getModel()).isDefinitionFile() && AccessModifier.PRIVATE != ((N4JSClassifierWizardModel)this.getModel()).getAccessModifier())));
        ISWTObservableValue internalEnabledValue = WidgetProperties.enabled().observe((Widget)this.accessModifierComponent.getInternalAnnotationBox());
        IObservableValue accessModifierSelectObservable = BeanProperties.value(N4JSClassifierWizardModel.class, (String)"accessModifier", AccessModifier.class).observe((Object)((N4JSClassifierWizardModel)this.getModel()));
        dataBindingContext.bindValue((IObservableValue)internalEnabledValue, accessModifierSelectObservable, N4JSNewClassifierWizardPage.noUpdateValueStrategy(), WizardComponentDataConverters.strategyForPredicate((Predicate<Object>)((Predicate)object -> {
            if (object instanceof AccessModifier) {
                return this.isInternalAccessModifierEnabled((AccessModifier)((Object)((Object)object)));
            }
            return false;
        })));
        ISWTObservableValue n4jsEnabledValue = WidgetProperties.enabled().observe((Widget)this.otherClassifierModifiersComponent.getN4jsAnnotationBox());
        dataBindingContext.bindValue((IObservableValue)n4jsEnabledValue, accessModifierSelectObservable, N4JSNewClassifierWizardPage.noUpdateValueStrategy(), WizardComponentDataConverters.strategyForPredicate((Predicate<Object>)((Predicate)object -> {
            if (object instanceof AccessModifier) {
                return (AccessModifier)((Object)((Object)object)) != AccessModifier.PRIVATE && ((N4JSClassifierWizardModel)this.getModel()).isDefinitionFile();
            }
            return false;
        })));
        IObservableValue observableValidationValue = BeanProperties.value((String)"validationResult", WorkspaceWizardModelValidator.ValidationResult.class).observe(this.getValidator());
        observableValidationValue.addValueChangeListener((IValueChangeListener)new IValueChangeListener<WorkspaceWizardModelValidator.ValidationResult>(){

            public void handleValueChange(ValueChangeEvent<? extends WorkspaceWizardModelValidator.ValidationResult> event) {
                N4JSNewClassifierWizardPage.this.onValidationChange((WorkspaceWizardModelValidator.ValidationResult)event.diff.getNewValue());
            }
        });
    }

    private boolean isInternalAccessModifierEnabled(AccessModifier modifier) {
        return modifier == AccessModifier.PUBLIC;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDataBindingContext().updateTargets();
    }

    @Override
    protected boolean setInitialFocus() {
        if (!super.setInitialFocus()) {
            this.nameComponent.setFocus();
        }
        return false;
    }

    @Override
    protected void updateContentPreview(WizardPreviewProvider.WizardPreview contentPreview) {
        Display.getCurrent().asyncExec(() -> {
            ContentBlock[] codeBlocks = this.getGenerator().generateContentPreview((N4JSClassifierWizardModel)this.getModel());
            contentPreview.setContent(codeBlocks);
            contentPreview.revealContentBlock(codeBlocks[codeBlocks.length - 1]);
            contentPreview.setInfo(((N4JSClassifierWizardModel)this.getModel()).computeFileLocation().toString());
        });
    }

    public abstract WorkspaceWizardGenerator<M> getGenerator();

    private void onValidationChange(WorkspaceWizardModelValidator.ValidationResult result) {
        if (result.valid) {
            this.setPageComplete(true);
            this.setMessage("Press finish to create the new " + ((N4JSClassifierWizardModel)this.getModel()).getClassifierName());
            this.setErrorMessage(null);
        } else {
            this.setPageComplete(false);
            this.setErrorMessage(result.errorMessage);
        }
    }

    private static <S, D> UpdateValueStrategy<S, D> noUpdateValueStrategy() {
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);
    }
}

