/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor.syntaxcoloring;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class HighlightingConfiguration
extends DefaultHighlightingConfiguration {
    public static final String REGEX_ID = "REGEX_ID";
    public static final String TEMPLATE_ID = "TEMPLATE_ID";
    public static final String TEMPLATE_DELIMITER_ID = "TEMPLATE_DELIMITER_ID";
    public static final String ANNOTATION_ID = "ANNOTATION_ID";
    public static final String TYPE_REF_ID = "TYPE_REF_ID";
    public static final String IDENTIFIER_ID = "IDENTIFIER_ID";
    public static final String IDENTIFIER_REF_ID = "IDENTIFIER_REF_ID";
    public static final String TYPE_VARIABLE_ID = "TYPE_VARIABLE_ID";
    public static final String JS_DOC_ID = "JS_DOC_ID";
    public static final String ES5_KW_ID = "ES5_KW_ID";
    public static final String ES6_KW_ID = "ES6_KW_ID";
    public static final String FUTURE_KW_ID = "FUTURE_KW_ID";
    public static final String NULL_LITERAL_ID = "NULL_LITERAL_ID";
    public static final String BOOLEAN_LITERAL_ID = "BOOLEAN_LITERAL_ID";
    public static final String N4JS_KW_ID = "N4JS_KW_ID";

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        acceptor.acceptDefaultHighlighting("punctuation", "Punctuation character", this.punctuationTextStyle());
        acceptor.acceptDefaultHighlighting("comment", "Comment", this.commentTextStyle());
        acceptor.acceptDefaultHighlighting("task", "Task Tag", this.taskTextStyle());
        acceptor.acceptDefaultHighlighting("string", "String", this.stringTextStyle());
        acceptor.acceptDefaultHighlighting("number", "Number", this.numberTextStyle());
        acceptor.acceptDefaultHighlighting("default", "Default", this.defaultTextStyle());
        acceptor.acceptDefaultHighlighting("error", "Invalid Symbol", this.errorTextStyle());
        acceptor.acceptDefaultHighlighting(REGEX_ID, "Regular Expression", this.regExTextStyle());
        acceptor.acceptDefaultHighlighting(TEMPLATE_ID, "Template Text", this.literalTextStyle());
        acceptor.acceptDefaultHighlighting(TEMPLATE_DELIMITER_ID, "Template Delimiter", this.templateDelimiterTextStyle());
        acceptor.acceptDefaultHighlighting(ANNOTATION_ID, "Annotation", this.annotationTextStyle());
        acceptor.acceptDefaultHighlighting(TYPE_REF_ID, "Type Reference", this.typeRefTextStyle());
        acceptor.acceptDefaultHighlighting(IDENTIFIER_ID, "Identifier", this.defaultTextStyle());
        acceptor.acceptDefaultHighlighting(IDENTIFIER_REF_ID, "Reference", this.defaultTextStyle());
        acceptor.acceptDefaultHighlighting(TYPE_VARIABLE_ID, "Type Variable", this.defaultTextStyle());
        acceptor.acceptDefaultHighlighting(JS_DOC_ID, "JSDoc Comment", this.jsDocTextStyle());
        acceptor.acceptDefaultHighlighting(ES5_KW_ID, "ES5 Keywords", this.keywordTextStyle());
        acceptor.acceptDefaultHighlighting(ES6_KW_ID, "ES6 Keywords", this.keywordTextStyle());
        acceptor.acceptDefaultHighlighting(FUTURE_KW_ID, "Reserved words", this.keywordTextStyle());
        acceptor.acceptDefaultHighlighting(N4JS_KW_ID, "N4JS Keywords", this.keywordTextStyle());
        acceptor.acceptDefaultHighlighting(NULL_LITERAL_ID, "Null literals", this.keywordTextStyle());
        acceptor.acceptDefaultHighlighting(BOOLEAN_LITERAL_ID, "Boolean literals", this.keywordTextStyle());
    }

    private TextStyle annotationTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(255, 0, 255));
        return textStyle;
    }

    private TextStyle typeRefTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(140, 140, 140));
        return textStyle;
    }

    public TextStyle regExTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(255, 128, 64));
        return textStyle;
    }

    public TextStyle templateDelimiterTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(255, 183, 51));
        return textStyle;
    }

    public TextStyle literalTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(0, 0, 255));
        return textStyle;
    }

    public TextStyle jsDocTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(90, 139, 227));
        return textStyle;
    }

    public TextStyle numberTextStyle() {
        return this.literalTextStyle();
    }
}

