/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.n4js.smith.ui.graph.GraphUtils;
import org.eclipse.n4js.smith.ui.graph.Node;
import org.eclipse.n4js.smith.ui.graph.Point;
import org.eclipse.n4js.smith.ui.graph.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class Edge {
    protected String label;
    protected final List<Node> startNodes = new ArrayList<Node>();
    protected final List<Node> endNodes = new ArrayList<Node>();
    protected final List<String> endNodesExternal = new ArrayList<String>();
    protected boolean crossLink;

    public Edge(String label, boolean crossLink, Node startNode, Collection<? extends Node> endNodes, Collection<String> endNodesExternal) {
        this(label, crossLink, Collections.singletonList(startNode), endNodes, endNodesExternal);
    }

    public Edge(String label, boolean crossLink, Collection<? extends Node> startNodes, Collection<? extends Node> endNodes, Collection<String> endNodesExternal) {
        this.label = label;
        this.crossLink = crossLink;
        this.startNodes.addAll(startNodes);
        this.endNodes.addAll(endNodes);
        this.endNodesExternal.addAll(endNodesExternal);
    }

    public String getLabel() {
        return this.label;
    }

    public List<Node> getNodes() {
        return GraphUtils.concat(this.startNodes, this.endNodes);
    }

    public Node getFirstStartNode() {
        return this.startNodes.isEmpty() ? null : this.startNodes.get(0);
    }

    public List<Node> getStartNodes() {
        return this.startNodes;
    }

    public List<Node> getEndNodes() {
        return this.endNodes;
    }

    public List<String> getEndNodesExternal() {
        return this.endNodesExternal;
    }

    public void setCrossLink(boolean value) {
        this.crossLink = value;
    }

    public boolean isCrossLink() {
        return this.crossLink;
    }

    public boolean isStartNode(Node node) {
        return this.startNodes.contains(node);
    }

    public boolean isEndNode(Node node) {
        return this.endNodes.contains(node);
    }

    public boolean isInternal() {
        return !this.endNodes.isEmpty();
    }

    public boolean isExternal() {
        return !this.endNodesExternal.isEmpty();
    }

    public void paint(GC gc) {
        Point anchor;
        if (this.startNodes.isEmpty() || this.endNodes.isEmpty()) {
            return;
        }
        Display displ = Display.getCurrent();
        Color color = this.crossLink ? displ.getSystemColor(3) : displ.getSystemColor(16);
        gc.setForeground(color);
        List<Rectangle> nodesExternalBounds = this.drawTemporaryLabels(gc);
        List<Node> nodes = this.getNodes();
        List<Point> ctrPoints = this.getCenterPoints(nodesExternalBounds, nodes);
        Point rp = this.getReferencePoint(ctrPoints);
        for (Node startNode : this.startNodes) {
            anchor = startNode.getAnchor(this, rp);
            this.paintEdgeLine(gc, anchor, rp, false);
        }
        for (Node endNode : this.endNodes) {
            anchor = endNode.getAnchor(this, rp);
            this.paintEdgeLine(gc, rp, anchor, this.crossLink);
        }
        for (Rectangle extBound : nodesExternalBounds) {
            anchor = extBound.getIntersectionLocation(rp);
            this.paintEdgeLine(gc, rp, anchor, this.crossLink);
        }
        this.drawLabel(gc, nodes, rp);
    }

    protected void paintEdgeLine(GC gc, Point src, Point tgt, boolean drawArrow) {
        GraphUtils.drawLine(gc, src, tgt, drawArrow);
    }

    private void drawLabel(GC gc, List<Node> nodes, Point rp) {
        if (this.label == null) {
            return;
        }
        float x = rp.x;
        float y = rp.y;
        if (this.getStartNodes().size() == 1 && this.getEndNodes().size() == 1 && this.isCrossLink()) {
            Node labelNode = nodes.get(nodes.size() - 1);
            Point labelNodeAnchor = labelNode.getAnchor(this, rp);
            x = (labelNodeAnchor.x + rp.x) / 2.0f;
            y = (labelNodeAnchor.y + rp.y) / 2.0f;
        }
        GraphUtils.drawString(gc, this.label, x, y);
    }

    private Point getReferencePoint(List<Point> ctrPoints) {
        float minx = Float.MAX_VALUE;
        float maxx = Float.MIN_VALUE;
        float miny = Float.MAX_VALUE;
        float maxy = Float.MIN_VALUE;
        for (Point c : ctrPoints) {
            minx = Math.min(minx, c.x);
            maxx = Math.max(maxx, c.x);
            miny = Math.min(miny, c.y);
            maxy = Math.max(maxy, c.y);
        }
        float width = maxx - minx;
        float height = maxy - miny;
        Point rp = new Point(minx + width / 2.0f, miny + height / 2.0f);
        return rp;
    }

    private List<Point> getCenterPoints(List<Rectangle> nodesExternalBounds, List<Node> nodes) {
        Stream<Point> nodeCenters = nodes.stream().map(n -> n.getCenter());
        Stream<Point> extBoundCenters = nodesExternalBounds.stream().map(b -> b.getCenter());
        Stream<Point> allCenters = Stream.concat(nodeCenters, extBoundCenters);
        List<Point> ctrPoints = allCenters.collect(Collectors.toList());
        return ctrPoints;
    }

    private List<Rectangle> drawTemporaryLabels(GC gc) {
        ArrayList<Rectangle> nodesExternalBounds = new ArrayList<Rectangle>();
        Rectangle clip = GraphUtils.getClip(gc);
        float px = clip.x + clip.width;
        float py = clip.y + clip.height;
        for (String currNE : this.endNodesExternal) {
            org.eclipse.swt.graphics.Point size = gc.stringExtent(currNE);
            float rx = px - (float)(size.x + 4);
            Rectangle b = new Rectangle(rx, py -= (float)(size.y + 4), size.x, size.y);
            nodesExternalBounds.add(b);
            GraphUtils.drawString(gc, currNE, b.x + b.width / 2.0f, b.y + b.height / 2.0f);
        }
        return nodesExternalBounds;
    }
}

