/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries;

import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import org.apache.log4j.Logger;
import org.eclipse.n4js.binaries.BinariesConstants;
import org.eclipse.n4js.utils.ExecutableLookupUtil;
import org.eclipse.n4js.utils.process.OutputRedirection;
import org.eclipse.n4js.utils.process.ProcessExecutor;
import org.eclipse.n4js.utils.process.ProcessResult;

public class BinariesLocatorHelper {
    private static final Logger LOGGER = Logger.getLogger(BinariesLocatorHelper.class);
    private static final boolean LOG_SYSTEM_PROPERTIES = false;
    private static final boolean LOG_ENV_VARIABLES = false;
    private static final boolean LOG_TO_STD_OUT = false;
    @Inject
    private ProcessExecutor processExecutor;

    public Path findNodePath() {
        BinariesLocatorHelper.logSystemProperties();
        BinariesLocatorHelper.logEnvironmentVariables();
        Path nodePathCandidate = null;
        nodePathCandidate = BinariesLocatorHelper.resolveFolderContaingBinary(BinariesLocatorHelper.tryGetEnvOrSystemVariable("org.eclipse.n4js.defaultNodePath"));
        if (nodePathCandidate != null) {
            BinariesLocatorHelper.info("User specified default Node.js path will be used: '" + nodePathCandidate + ".' based on the '" + "org.eclipse.n4js.defaultNodePath" + "' VM argument.");
            return nodePathCandidate;
        }
        BinariesLocatorHelper.debug("Could not resolve node path from 'org.eclipse.n4js.defaultNodePath' VM argument.");
        nodePathCandidate = BinariesLocatorHelper.resolveFolderContaingBinary(BinariesLocatorHelper.tryGetEnvOrSystemVariable("NODEJS_PATH"));
        if (nodePathCandidate != null) {
            BinariesLocatorHelper.info("User specified default Node.js path will be used: '" + nodePathCandidate + ".' based on the '" + "NODEJS_PATH" + "' VM argument.");
            return nodePathCandidate;
        }
        BinariesLocatorHelper.debug("Could not resolve node path from 'NODEJS_PATH' VM argument.");
        nodePathCandidate = BinariesLocatorHelper.resolveFolderContaingBinary(ExecutableLookupUtil.findInPath((String)"node"));
        if (nodePathCandidate != null) {
            BinariesLocatorHelper.info("Obtained default Node.js path will be used: '" + nodePathCandidate + ".' based on the OS PATH.");
            return nodePathCandidate;
        }
        BinariesLocatorHelper.debug("Could not resolve node path from OS PATH variable.");
        nodePathCandidate = BinariesLocatorHelper.resolveFolderContaingBinary(this.lookForBinary("node"));
        if (nodePathCandidate != null) {
            BinariesLocatorHelper.info("Obtained default Node.js path will be used: '" + nodePathCandidate + ".' based on the OS dynamic lookup.");
            return nodePathCandidate;
        }
        BinariesLocatorHelper.debug("Could not resolve node path from OS dynamic lookup.");
        BinariesLocatorHelper.info("Could not resolve node path. Falling back to default path: " + nodePathCandidate);
        nodePathCandidate = new File(BinariesConstants.BUILT_IN_DEFAULT_NODE_PATH).toPath();
        return nodePathCandidate;
    }

    public Path findYarnPath() {
        Path yarnPathCandidate = null;
        yarnPathCandidate = BinariesLocatorHelper.resolveFolderContaingBinary(BinariesLocatorHelper.tryGetEnvOrSystemVariable("org.eclipse.n4js.defaultYarnPath"));
        if (yarnPathCandidate != null) {
            BinariesLocatorHelper.info("User specified default Yarn path will be used: '" + yarnPathCandidate + ".' based on the '" + "org.eclipse.n4js.defaultYarnPath" + "' VM argument.");
            return yarnPathCandidate;
        }
        BinariesLocatorHelper.debug("Could not resolve node path from 'org.eclipse.n4js.defaultNodePath' VM argument.");
        yarnPathCandidate = BinariesLocatorHelper.resolveFolderContaingBinary(BinariesLocatorHelper.tryGetEnvOrSystemVariable("YARN_PATH"));
        if (yarnPathCandidate != null) {
            BinariesLocatorHelper.info("User specified default yarn path will be used: '" + yarnPathCandidate + ".' based on the '" + "YARN_PATH" + "' environment argument.");
            return yarnPathCandidate;
        }
        BinariesLocatorHelper.debug("Could not resolve yarn path from 'YARN_PATH");
        yarnPathCandidate = BinariesLocatorHelper.resolveFolderContaingBinary(ExecutableLookupUtil.findInPath((String)"yarn"));
        if (yarnPathCandidate != null) {
            BinariesLocatorHelper.info("Obtained yarn path will be used: '" + yarnPathCandidate + ".' based on the OS PATH.");
            return yarnPathCandidate;
        }
        BinariesLocatorHelper.debug("Could not resolve yarn path from OS PATH variable.");
        yarnPathCandidate = BinariesLocatorHelper.resolveFolderContaingBinary(this.lookForBinary("yarn"));
        if (yarnPathCandidate != null) {
            BinariesLocatorHelper.info("Obtained yarn path will be used: '" + yarnPathCandidate + ".' based on the OS dynamic lookup.");
            return yarnPathCandidate;
        }
        BinariesLocatorHelper.debug("Could not resolve yarn path from OS dynamic lookup.");
        BinariesLocatorHelper.info("Could not resolve yarn path. Falling back to default path: " + yarnPathCandidate);
        yarnPathCandidate = new File(BinariesConstants.BUILT_IN_DEFAULT_YARN_PATH).toPath();
        return yarnPathCandidate;
    }

    private String lookForBinary(String binaryName) {
        ProcessResult processResult = this.processExecutor.createAndExecute(ExecutableLookupUtil.getExebutableLookupProcessBuilder((String)binaryName), "look for " + binaryName, OutputRedirection.SUPPRESS);
        return processResult.getStdOut().trim();
    }

    private static String tryGetEnvOrSystemVariable(String propertyName) {
        String nodeJsPath = System.getenv(propertyName);
        if (BinariesLocatorHelper.isNullOrEmptyOrNullString(nodeJsPath)) {
            return System.getProperty(propertyName);
        }
        return nodeJsPath;
    }

    private static Path resolveFolderContaingBinary(String binaryPathCandidate) {
        if (BinariesLocatorHelper.isNullOrEmptyOrNullString(binaryPathCandidate)) {
            return null;
        }
        File binaryDir = new File(binaryPathCandidate);
        if (binaryDir.isFile()) {
            binaryDir = binaryDir.getParentFile();
        } else {
            if (!binaryDir.exists()) {
                return null;
            }
            if (!binaryDir.isDirectory()) {
                return null;
            }
        }
        return binaryDir.getAbsoluteFile().toPath();
    }

    private static boolean isNullOrEmptyOrNullString(String s) {
        return s == null || s.trim().length() == 0 || "null".equals(s);
    }

    private static void logSystemProperties() {
    }

    private static void logEnvironmentVariables() {
    }

    private static void info(Object message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info(message);
        }
    }

    private static void debug(Object message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message);
        }
    }
}

