/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectModel.lsp.ex;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.lsp.ex.ISourceFolderEx;
import org.eclipse.n4js.projectModel.lsp.ex.IWorkspaceConfigEx;
import org.eclipse.xtext.workspace.IProjectConfig;

public interface IProjectConfigEx
extends IProjectConfig {
    public IWorkspaceConfigEx getWorkspaceConfig();

    public Set<? extends ISourceFolderEx> getSourceFolders();

    default public ISourceFolderEx findSourceFolderContaining(URI member) {
        for (ISourceFolderEx iSourceFolderEx : this.getSourceFolders()) {
            if (!iSourceFolderEx.contains(member)) continue;
            return iSourceFolderEx;
        }
        return null;
    }

    public Iterable<URI> getOutputFolders();

    default public boolean isInSourceFolder(URI member) {
        return this.findSourceFolderContaining(member) != null;
    }

    default public boolean isInOutputFolder(URI member) {
        Path memberPath = Paths.get(member.path(), new String[0]);
        for (URI outputFolder : this.getOutputFolders()) {
            Path outputPath = Paths.get(outputFolder.path(), new String[0]);
            if (!memberPath.startsWith(outputPath)) continue;
            return true;
        }
        return false;
    }
}

