/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.utils;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ThisTarget;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeExtensions;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelperStrategy;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ThisTypeComputer
extends TypeSystemHelperStrategy {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public TypeRef getThisTypeAtLocation(RuleEnvironment G, EObject location) {
        IdentifiableElement containingTFunctionOrAccessor;
        TypeRef declaredThisTypeRef;
        if (location instanceof ParameterizedTypeRef) {
            return TypeUtils.createBoundThisTypeRef((ParameterizedTypeRef)((ParameterizedTypeRef)location));
        }
        FunctionOrFieldAccessor containingFunctionOrAccessor = N4JSASTUtils.getContainingFunctionOrAccessor((EObject)location);
        if (containingFunctionOrAccessor instanceof ArrowFunction) {
            return this.getThisTypeAtLocation(G, (EObject)containingFunctionOrAccessor);
        }
        IdentifiableElement _xifexpression = null;
        if (containingFunctionOrAccessor != null) {
            _xifexpression = containingFunctionOrAccessor.getDefinedFunctionOrAccessor();
        }
        if ((declaredThisTypeRef = TypeSystemHelper.getDeclaredThisType(containingTFunctionOrAccessor = _xifexpression)) != null) {
            if (declaredThisTypeRef instanceof ParameterizedTypeRef) {
                return this.getThisTypeAtLocation(G, (EObject)declaredThisTypeRef);
            }
            return declaredThisTypeRef;
        }
        ThisTarget thisTarget = N4JSASTUtils.getProbableThisTarget((EObject)location);
        if (thisTarget instanceof ObjectLiteral) {
            return this.ts.type(G, (TypableElement)thisTarget);
        }
        if (thisTarget instanceof N4ClassifierDefinition) {
            Type actualClazz;
            TClass clazz;
            Type thisTargetDefType = ((N4ClassifierDefinition)thisTarget).getDefinedType();
            if (thisTarget instanceof N4ClassDeclaration && (clazz = ((N4ClassDeclaration)thisTarget).getDefinedTypeAsClass()) != null && clazz.isStaticPolyfill() && (actualClazz = clazz.getSuperClassRef().getDeclaredType()) != null) {
                thisTargetDefType = actualClazz;
            }
            if (thisTargetDefType != null) {
                FunctionDefinition containingFunction = N4JSASTUtils.getContainingFunction((EObject)location);
                if (containingFunction instanceof N4MethodDeclaration && ((N4MemberDeclaration)containingFunction).isStatic()) {
                    boolean _isInReturnDeclaration_Of_StaticMethod = RuleEnvironmentExtensions.isInReturnDeclaration_Of_StaticMethod(location, (N4MethodDeclaration)containingFunction);
                    if (_isInReturnDeclaration_Of_StaticMethod) {
                        return this.getThisTypeAtLocation(G, (EObject)this.createTypeRefWithParamsAsArgs(thisTargetDefType));
                    }
                    boolean _isInBody_Of_StaticMethod = RuleEnvironmentExtensions.isInBody_Of_StaticMethod(location, (N4MethodDeclaration)containingFunction);
                    if (_isInBody_Of_StaticMethod) {
                        return TypeUtils.createClassifierBoundThisTypeRef((TypeTypeRef)TypeUtils.createTypeTypeRef((TypeArgument)this.createTypeRefWithParamsAsArgs(thisTargetDefType), (boolean)false));
                    }
                    return TypeUtils.createConstructorTypeRef((Type)thisTargetDefType, (TypeArgument[])new TypeArgument[0]);
                }
                N4FieldDeclaration n4Field = (N4FieldDeclaration)EcoreUtil2.getContainerOfType((EObject)location, N4FieldDeclaration.class);
                if (n4Field != null && n4Field.isStatic()) {
                    return TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
                }
                N4GetterDeclaration n4Getter = (N4GetterDeclaration)EcoreUtil2.getContainerOfType((EObject)location, N4GetterDeclaration.class);
                if (n4Getter != null && n4Getter.isStatic()) {
                    return TypeUtils.createConstructorTypeRef((Type)thisTargetDefType, (TypeArgument[])new TypeArgument[0]);
                }
                N4SetterDeclaration n4Setter = (N4SetterDeclaration)EcoreUtil2.getContainerOfType((EObject)location, N4SetterDeclaration.class);
                if (n4Setter != null && n4Setter.isStatic()) {
                    return TypeUtils.createConstructorTypeRef((Type)thisTargetDefType, (TypeArgument[])new TypeArgument[0]);
                }
                return this.getThisTypeAtLocation(G, (EObject)this.createTypeRefWithParamsAsArgs(thisTargetDefType));
            }
            return RuleEnvironmentExtensions.anyTypeRefDynamic(G);
        }
        boolean _hasGlobalObject = this.jsVariantHelper.hasGlobalObject(location);
        if (_hasGlobalObject) {
            return RuleEnvironmentExtensions.globalObjectTypeRef(G);
        }
        return RuleEnvironmentExtensions.undefinedTypeRef(G);
    }

    private TypeRef createTypeRefWithParamsAsArgs(Type type) {
        boolean _isGeneric = type.isGeneric();
        if (_isGeneric) {
            Functions.Function1 _function = it -> TypeExtensions.ref((Type)it, (TypeArgument[])new TypeArgument[0]);
            List typeArgs = IterableExtensions.toList((Iterable)ListExtensions.map((List)type.getTypeVars(), (Functions.Function1)_function));
            return TypeExtensions.ref((Type)type, (TypeArgument[])((TypeArgument[])Conversions.unwrapArray((Object)typeArgs, TypeArgument.class)));
        }
        return TypeExtensions.ref((Type)type, (TypeArgument[])new TypeArgument[0]);
    }
}

