/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.server.N4JSBuildManager;
import org.eclipse.xtext.ide.server.BuildManager;
import org.eclipse.xtext.ide.server.WorkspaceManager;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class N4JSWorkspaceManager
extends WorkspaceManager {
    private Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor;
    private N4JSBuildManager accessibleBuildManager;

    public void initialize(URI pBaseDir, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> pIssueAcceptor, CancelIndicator cancelIndicator) {
        super.initialize(pBaseDir, pIssueAcceptor, cancelIndicator);
        this.issueAcceptor = pIssueAcceptor;
    }

    @Inject
    public void setBuildManager(BuildManager buildManager) {
        super.setBuildManager(buildManager);
        this.accessibleBuildManager = (N4JSBuildManager)buildManager;
    }

    N4JSBuildManager getBuildManager() {
        return this.accessibleBuildManager;
    }

    public BuildManager.Buildable didClose(final URI uri) {
        final IProjectConfig projectConfig = this.getWorkspaceConfig().findProjectContaining(uri);
        final BuildManager.Buildable closedBuildable = super.didClose(uri);
        BuildManager.Buildable cleaningBuildable = new BuildManager.Buildable(){

            public List<IResourceDescription.Delta> build(CancelIndicator cancelIndicator) {
                List build = closedBuildable.build(cancelIndicator);
                ISourceFolder sourceFolder = projectConfig.findSourceFolderContaining(uri);
                if (sourceFolder == null) {
                    N4JSWorkspaceManager.this.clearIssues(uri);
                }
                return build;
            }
        };
        return cleaningBuildable;
    }

    public URI getBaseDir() {
        try {
            Field field = WorkspaceManager.class.getDeclaredField("baseDir");
            field.setAccessible(true);
            Object value = field.get((Object)this);
            URI baseDir = (URI)value;
            return baseDir;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void clearIssues(URI uri) {
        this.issueAcceptor.apply((Object)uri, Collections.emptyList());
    }

    public IWorkspaceConfig getWorkspaceConfig() {
        return super.getWorkspaceConfig();
    }
}

