/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.compiler;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.n4js.cli.N4jscConsole;
import org.eclipse.n4js.cli.compiler.IssueSerializer;

@Singleton
public class N4jscLanguageClient
implements LanguageClient {
    @Inject
    protected IssueSerializer issueSerializer;

    public void telemetryEvent(Object object) {
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        List issueList = diagnostics.getDiagnostics();
        if (issueList.isEmpty()) {
            return;
        }
        N4jscConsole.println(this.issueSerializer.uri(diagnostics.getUri()));
        for (Diagnostic diag : issueList) {
            N4jscConsole.println(this.issueSerializer.diagnostics(diag));
        }
    }

    public void showMessage(MessageParams messageParams) {
        N4jscConsole.println(messageParams.getMessage());
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        return null;
    }

    public void logMessage(MessageParams message) {
        N4jscConsole.println(message.getMessage());
    }
}

