/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.quickfix;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.changes.SemanticChangeProvider;
import org.eclipse.n4js.ui.quickfix.QuickfixUtil;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class TopLevelVisibilityFixProvider {
    private static final String INTERNAL_ANNOTATION = AnnotationDefinition.INTERNAL.name;
    @Inject
    SemanticChangeProvider semanticChangeProvider;

    TopLevelVisibilityFix provideFixFor(String typeLabel, String suggestion) {
        return new TopLevelVisibilityFix(typeLabel, suggestion);
    }

    public class TopLevelVisibilityFix {
        private final String description;
        private N4Modifier modifier = N4Modifier.PUBLIC;
        private boolean internal = false;
        private final boolean export = true;

        TopLevelVisibilityFix(String typeLabel, String suggestion) throws IllegalArgumentException {
            this.description = "Declare " + typeLabel + " as export " + QuickfixUtil.readableStringForSuggestion(suggestion);
            this.modifier = QuickfixUtil.modifierForSuggestion(suggestion);
            this.internal = QuickfixUtil.modifierSuggestionIsInternal(suggestion);
        }

        IChange[] changes(EObject element, IXtextDocument doc) throws BadLocationException {
            ArrayList<IChange> changes = new ArrayList<IChange>();
            if (element instanceof TypeDefiningElement) {
                changes.add(TopLevelVisibilityFixProvider.this.semanticChangeProvider.setAccessModifier(doc, (TypeDefiningElement)element, this.modifier, true));
            } else if (element instanceof ExportedVariableStatement) {
                changes.add(TopLevelVisibilityFixProvider.this.semanticChangeProvider.setAccessModifiers(doc, (ModifiableElement)element, this.modifier));
            } else {
                return changes.toArray(new IChange[changes.size()]);
            }
            if (element instanceof AnnotableElement) {
                if (this.internal) {
                    changes.add(TopLevelVisibilityFixProvider.this.semanticChangeProvider.addAnnotation(doc, (AnnotableElement)element, INTERNAL_ANNOTATION));
                } else {
                    changes.add(TopLevelVisibilityFixProvider.this.semanticChangeProvider.removeAnnotation(doc, (AnnotableElement)element, INTERNAL_ANNOTATION));
                }
                return changes.toArray(new IChange[changes.size()]);
            }
            return new IChange[0];
        }

        String getDescription() {
            return this.description;
        }

        boolean isExport() {
            return true;
        }

        N4Modifier getModifier() {
            return this.modifier;
        }

        boolean isInternal() {
            return this.internal;
        }
    }
}

