/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.workspace;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;

public class WorkspaceWizardValidatorUtils {
    private static final Pattern VALID_FOLDER_NAME_PATTERN = Pattern.compile("[a-zA-z_](([a-zA-z_0-9-])|[a-zA-z_0-9-])*");
    private static final Pattern NO_BACKSLASH_PATTERN = Pattern.compile("[^\\\\]+");

    public static boolean isValidFolderName(String name) {
        return VALID_FOLDER_NAME_PATTERN.matcher(name).matches() && NO_BACKSLASH_PATTERN.matcher(name).matches();
    }

    public static boolean isValidFolderPath(IPath path) {
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!WorkspaceWizardValidatorUtils.isValidFolderName(segment)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private WorkspaceWizardValidatorUtils() {
    }
}

