/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import java.util.List;
import org.eclipse.n4js.scoping.members.ComposedMemberFactory;
import org.eclipse.n4js.scoping.members.ComposedMemberInfo;
import org.eclipse.n4js.scoping.members.FieldFactory;
import org.eclipse.n4js.scoping.members.GetterFactory;
import org.eclipse.n4js.scoping.members.MemberFactory;
import org.eclipse.n4js.scoping.members.MethodFactory;
import org.eclipse.n4js.scoping.members.SetterFactory;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TMember;

public class IntersectionMemberFactory
extends ComposedMemberFactory {
    IntersectionMemberFactory(ComposedMemberInfo cma) {
        super(cma);
    }

    @Override
    protected MemberFactory getMemberFactory() {
        switch (this.memberType) {
            case METHOD: {
                return new MethodFactory.IntersectionMethodFactory(this.cmi);
            }
            case FIELD: {
                return new FieldFactory.IntersectionFieldFactory(this.cmi);
            }
            case GETTER: {
                return new GetterFactory.IntersectionGetterFactory(this.cmi);
            }
            case SETTER: {
                return new SetterFactory.IntersectionSetterFactory(this.cmi);
            }
        }
        return null;
    }

    @Override
    protected MemberType getNewMemberType() {
        if (this.cmi.hasMethodMemberType() && this.cmi.hasNonMethodMemberType()) {
            return null;
        }
        if (this.cmi.onlyMethodMemberTypes()) {
            return MemberType.METHOD;
        }
        if (this.cmi.onlyGetterMemberTypes() && !this.cmi.isWriteAccess()) {
            return MemberType.GETTER;
        }
        if (this.cmi.onlySetterMemberTypes() && this.cmi.isWriteAccess()) {
            return MemberType.SETTER;
        }
        if (this.allTypeRefAreEqual()) {
            return MemberType.FIELD;
        }
        if (this.cmi.isWriteAccess()) {
            this.cmi.hasGetterMemberType();
            return MemberType.SETTER;
        }
        if (!this.cmi.isWriteAccess()) {
            this.cmi.hasSetterMemberType();
            return MemberType.GETTER;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.specialMemberFactory == null) {
            return false;
        }
        return this.specialMemberFactory.isValid();
    }

    @Override
    public List<TMember> getConstituentMembers() {
        return this.cmi.getConstituentMembers();
    }
}

