/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public class CopyrightHeader {
    static final String DEFAULT_CRH_FILE_NAME = "copyrightheader.adoc";
    static String COPYRIGHT_HEADER = "";

    public static void set(String header) {
        if (header == null) {
            header = "";
        }
        COPYRIGHT_HEADER = header;
    }

    public static boolean isEmpty() {
        return COPYRIGHT_HEADER == null || COPYRIGHT_HEADER.isEmpty();
    }

    public static String getAdoc() {
        if (CopyrightHeader.isEmpty()) {
            return "";
        }
        return "////\n" + COPYRIGHT_HEADER + "\n////\n\n";
    }

    public static String getIdx() {
        if (CopyrightHeader.isEmpty()) {
            return "";
        }
        return CopyrightHeader.getCrhForIdxFiles();
    }

    private static String getCrhForIdxFiles() {
        String newCRH = "#\n# " + String.join((CharSequence)"\n# ", COPYRIGHT_HEADER.split("\n")) + "\n#\n\n";
        newCRH = newCRH.replaceAll(" \n", "\n");
        return newCRH;
    }

    public static String readDefault(Path path) {
        Path defaultCRH = path.resolve(DEFAULT_CRH_FILE_NAME);
        String crh = "";
        try {
            List<String> lines = Files.readAllLines(defaultCRH, StandardCharsets.UTF_8);
            crh = String.join((CharSequence)"\n", lines);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return crh.trim();
    }
}

