/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor;

import java.lang.reflect.Field;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ui.editor.PrevStateAwareDocumentBasedDirtyResource;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.DirtyStateManager;
import org.eclipse.xtext.ui.editor.DocumentBasedDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyResource;

public class PrevStateAwareDirtyStateManager
extends DirtyStateManager {
    protected void notifyListeners(final IDirtyResource dirtyResource, boolean managed) {
        if (managed) {
            final IResourceDescription prevState = this.extractOldDescription(dirtyResource);
            IResourceDescription.Delta delta = new IResourceDescription.Delta(){

                public boolean haveEObjectDescriptionsChanged() {
                    return true;
                }

                public IResourceDescription getOld() {
                    return prevState;
                }

                public IResourceDescription getNew() {
                    return dirtyResource.getDescription();
                }

                public URI getUri() {
                    return dirtyResource.getURI();
                }
            };
            this.notifyListeners(delta);
        } else {
            IResourceDescription.Delta delta = new IResourceDescription.Delta(){

                public boolean haveEObjectDescriptionsChanged() {
                    return true;
                }

                public IResourceDescription getOld() {
                    return dirtyResource.getDescription();
                }

                public IResourceDescription getNew() {
                    return null;
                }

                public URI getUri() {
                    return dirtyResource.getURI();
                }
            };
            this.notifyListeners(delta);
        }
    }

    private void notifyListeners(IResourceDescription.Delta delta) {
        this.notifyListeners((IResourceDescription.Event)new ResourceDescriptionChangeEvent(Collections.singletonList(delta)));
    }

    private IResourceDescription extractOldDescription(IDirtyResource dirtyResource) {
        DocumentBasedDirtyResource myDirtyResource = this.reflectiveGetInnerResource(dirtyResource);
        if (myDirtyResource instanceof PrevStateAwareDocumentBasedDirtyResource) {
            return ((PrevStateAwareDocumentBasedDirtyResource)myDirtyResource).getPrevDescription();
        }
        return null;
    }

    private DocumentBasedDirtyResource reflectiveGetInnerResource(IDirtyResource dirtyResource) {
        Field[] declaredFields = dirtyResource.getClass().getDeclaredFields();
        DocumentBasedDirtyResource myDirtyResource = null;
        try {
            Field field = declaredFields[0];
            field.setAccessible(true);
            Object fieldValue = field.get(dirtyResource);
            if (fieldValue instanceof DirtyStateEditorSupport) {
                myDirtyResource = ((DirtyStateEditorSupport)fieldValue).getDirtyResource();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return myDirtyResource;
    }
}

