/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;

public class N4JSSourceContainerPropertyTester
extends PropertyTester {
    @Inject
    private IN4JSCore core;

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IResource) {
            IN4JSProject n4Project;
            IProject project;
            IResource resource = (IResource)receiver;
            if (resource instanceof IProject) {
                IN4JSProject n4Project2 = this.getN4Project((IProject)resource);
                return this.isExistingN4Project(n4Project2);
            }
            if (resource instanceof IFolder && (project = resource.getProject()) != null && project.isAccessible() && this.isExistingN4Project(n4Project = this.getN4Project(project))) {
                String relativePath = resource.getProjectRelativePath().toString();
                if (this.isSourceContainer(n4Project, relativePath)) {
                    return true;
                }
                if (resource.getParent() instanceof IFolder) {
                    return this.test(resource.getParent(), property, args, expectedValue);
                }
            }
        }
        return false;
    }

    private boolean isSourceContainer(IN4JSProject n4Project, String relativePath) {
        return FluentIterable.from((Iterable)n4Project.getSourceContainers()).transform(src -> src.getRelativeLocation()).contains((Object)relativePath);
    }

    private IN4JSProject getN4Project(IProject project) {
        return (IN4JSProject)this.core.findProject(URI.createPlatformResourceURI((String)project.getName(), (boolean)true)).orNull();
    }

    private boolean isExistingN4Project(IN4JSProject n4Project) {
        return n4Project != null && n4Project.exists() && !n4Project.isExternal();
    }
}

