/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.antlr.compressor;

import java.util.HashMap;
import java.util.Map;

public class IfElseCascade {
    static final String MATRIX_CLASS = "T2S";
    static final String MATRIX_PREFIX = "M_";
    final int start;
    final int end;
    final boolean bElse;
    final String tokenVarName;
    final String condition;
    final Map<String, Integer> tokenToStateMap;

    public IfElseCascade(int start, int end, boolean bElse, String tokenVarName, String condition, Map<String, Integer> tokenToStateMap) {
        this.start = start;
        this.end = end;
        this.bElse = bElse;
        this.tokenVarName = tokenVarName;
        this.condition = condition;
        this.tokenToStateMap = tokenToStateMap;
    }

    public Replacement getReplacements(Map<String, Integer> tokensToValues, int id) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        HashMap<Integer, Integer> valueToState = new HashMap<Integer, Integer>();
        for (Map.Entry<String, Integer> t2s : this.tokenToStateMap.entrySet()) {
            String token = t2s.getKey();
            int state = t2s.getValue();
            Integer iValue = tokensToValues.get(token);
            if (iValue == null) {
                throw new IllegalStateException("No constant value of " + token + " found in grammar file.");
            }
            int value = iValue;
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            valueToState.put(value, state);
        }
        String arrayLiteral = this.createArrayLiteral(min, max, valueToState);
        return new Replacement(id, arrayLiteral, min, max);
    }

    public static String getMatrixName(int id) {
        return "T2S.M_" + id;
    }

    public static String getMatrixNameSimple(int id) {
        return MATRIX_PREFIX + id;
    }

    private String createArrayLiteral(int min, int max, Map<Integer, Integer> valueToState) {
        StringBuilder m = new StringBuilder();
        m.append("{ ");
        int tokenValue = min;
        while (tokenValue <= max) {
            Integer state = valueToState.get(tokenValue);
            if (state == null) {
                m.append("-1");
            } else {
                m.append(state);
            }
            if (tokenValue < max) {
                m.append(", ");
            }
            ++tokenValue;
        }
        m.append("}");
        String matrix = m.toString();
        return matrix;
    }

    public int size() {
        return this.tokenToStateMap.size();
    }

    public String toString() {
        String s = this.bElse ? "else " : "";
        s = String.valueOf(s) + "if (";
        s = String.valueOf(s) + (this.tokenVarName != null ? this.tokenVarName : "??");
        s = String.valueOf(s) + "==..";
        s = String.valueOf(s) + (this.condition != null ? " " + this.condition : "");
        s = String.valueOf(s) + ") - ";
        s = this.tokenToStateMap != null ? String.valueOf(s) + this.tokenToStateMap.size() + " times" : String.valueOf(s) + " not analyzed yet.";
        return s;
    }

    public class Replacement {
        private final int min;
        private final int max;
        private final int id;
        public final String arrayLiteral;

        Replacement(int id, String arrayLiteral, int min, int max) {
            this.arrayLiteral = arrayLiteral;
            this.min = min;
            this.max = max;
            this.id = id;
        }

        String getMatrixDefinition() {
            return "final static int[] " + IfElseCascade.getMatrixNameSimple(this.id) + " = " + this.arrayLiteral + ";";
        }

        String getStatement() {
            return this.getStatement(null);
        }

        String getStatement(String delegate) {
            String matrixName = delegate == null ? IfElseCascade.getMatrixName(this.id) : delegate;
            String stmt = String.valueOf(IfElseCascade.this.bElse ? "else " : "") + "if ((" + IfElseCascade.this.tokenVarName + ">=" + this.min + " && " + IfElseCascade.this.tokenVarName + "<=" + this.max + " && (s=" + matrixName + "[" + IfElseCascade.this.tokenVarName + "-(" + this.min + ")]" + ")>=0)" + (IfElseCascade.this.condition.isEmpty() ? "" : " " + IfElseCascade.this.condition) + ") { /* " + IfElseCascade.this.tokenToStateMap.size() + " cases */ }";
            return stmt;
        }
    }
}

