/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.editor.contentassist;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.n4js.ide.editor.contentassist.ImportsAwareReferenceProposalCreator;
import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;

public class N4JSIdeContentProposalProvider
extends IdeContentProposalProvider {
    @Inject
    private N4JSGrammarAccess n4jsGrammarAccess;
    @Inject
    private ImportsAwareReferenceProposalCreator importsAwareReferenceProposalCreator;

    protected void _createProposals(CrossReference crossReference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        EReference ref;
        String featureName;
        ParserRule containingParserRule = GrammarUtil.containingParserRule((EObject)crossReference);
        if (containingParserRule != this.n4jsGrammarAccess.getTypeReferenceRule() && (featureName = GrammarUtil.containingAssignment((EObject)crossReference).getFeature()) == TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType().getName()) {
            this.lookupCrossReference(crossReference, TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType(), context, acceptor, new N4JSCandidateFilter());
        }
        if (!GrammarUtil.isDatatypeRule((ParserRule)containingParserRule) && (ref = containingParserRule.isWildcard() ? GrammarUtil.getReference((CrossReference)crossReference, (EClass)context.getCurrentModel().eClass()) : GrammarUtil.getReference((CrossReference)crossReference)) != null) {
            this.lookupCrossReference(crossReference, ref, context, acceptor, new N4JSCandidateFilter());
        }
    }

    protected void lookupCrossReference(CrossReference crossReference, EReference reference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        if (reference.getEReferenceType().isSuperTypeOf(TypesPackage.Literals.TYPE) || TypesPackage.Literals.TYPE.isSuperTypeOf(reference.getEReferenceType())) {
            this.importsAwareReferenceProposalCreator.lookupCrossReference(context.getCurrentModel(), reference, context, acceptor, filter, super.getProposalCreator());
        }
    }

    public static class N4JSCandidateFilter
    implements Predicate<IEObjectDescription> {
        public boolean apply(IEObjectDescription candidate) {
            QualifiedName qualifiedName = candidate.getQualifiedName();
            return !AbstractDescriptionWithError.isErrorDescription_XTEND_MVN_BUG_HACK((IEObjectDescription)candidate) && !N4TSQualifiedNameProvider.GLOBAL_NAMESPACE_SEGMENT.equals(qualifiedName.getFirstSegment()) && !N4TSQualifiedNameProvider.isModulePolyfill((QualifiedName)qualifiedName) && !N4TSQualifiedNameProvider.isPolyfill((QualifiedName)qualifiedName);
        }
    }
}

