/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.n4js.utils.process.OutputRedirection;
import org.eclipse.n4js.utils.process.OutputStreamPrinterThread;
import org.eclipse.n4js.utils.process.OutputStreamProvider;

@Singleton
public class NpmLogger {
    @Inject
    private OutputStreamProvider osProvider;
    private static Logger LOGGER = Logger.getLogger(NpmLogger.class);
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){
        private final SimpleDateFormat delegate = new SimpleDateFormat("[dd-MM-yyyy hh:mm:ss] ");

        @Override
        public SimpleDateFormat get() {
            return this.delegate;
        }

        @Override
        public void set(SimpleDateFormat value) {
        }
    };

    public void logInfo(String message) {
        LOGGER.info((Object)message);
        PrintWriter pw = new PrintWriter(this.osProvider.getOutputStream(OutputStreamPrinterThread.OutputStreamType.STD_OUT, OutputRedirection.REDIRECT));
        pw.append(String.valueOf(this.getTimestamp()) + message + System.lineSeparator());
        pw.flush();
    }

    public void logError(IStatus status) {
        this.logError(status.getMessage(), status.getException());
        Object[] children = status.getChildren();
        if (!Arrays2.isEmpty((Object[])children)) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.logError((IStatus)child);
                ++n2;
            }
        }
    }

    public void logError(String message, Throwable t) {
        LOGGER.error((Object)message, t);
        PrintWriter pw = new PrintWriter(this.osProvider.getOutputStream(OutputStreamPrinterThread.OutputStreamType.STD_ERR, OutputRedirection.SUPPRESS));
        pw.append(String.valueOf(this.getTimestamp()) + message + System.lineSeparator());
        if (t != null) {
            pw.append(String.valueOf(this.getTimestamp()) + Throwables.getStackTraceAsString((Throwable)t) + System.lineSeparator());
        }
        pw.flush();
    }

    private String getTimestamp() {
        return DATE_FORMAT.get().format(new Date());
    }
}

