/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.utils;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class CompositeScope
implements IScope {
    protected final IScope[] childScopes;

    public static final IScope create(IScope ... scopes) {
        if (scopes.length == 0) {
            return IScope.NULLSCOPE;
        }
        return new CompositeScope(scopes);
    }

    public static final IScope create(List<IScope> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return IScope.NULLSCOPE;
        }
        IScope[] arrayScopes = new IScope[scopes.size()];
        scopes.toArray(arrayScopes);
        return new CompositeScope(arrayScopes);
    }

    protected CompositeScope(IScope ... scopes) {
        this.childScopes = scopes;
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription result = null;
        IScope[] iScopeArray = this.childScopes;
        int n = this.childScopes.length;
        int n2 = 0;
        while (n2 < n) {
            IScope currScope = iScopeArray[n2];
            IEObjectDescription currResult = currScope.getSingleElement(name);
            if (currResult != null) {
                if (!IEObjectDescriptionWithError.isErrorDescription((IEObjectDescription)currResult)) {
                    return currResult;
                }
                if (result == null) {
                    result = currResult;
                }
            }
            ++n2;
        }
        return result;
    }

    public IEObjectDescription getSingleElement(EObject object) {
        IEObjectDescription result = null;
        IScope[] iScopeArray = this.childScopes;
        int n = this.childScopes.length;
        int n2 = 0;
        while (n2 < n) {
            IScope currScope = iScopeArray[n2];
            IEObjectDescription currResult = currScope.getSingleElement(object);
            if (currResult != null) {
                if (!IEObjectDescriptionWithError.isErrorDescription((IEObjectDescription)currResult)) {
                    return currResult;
                }
                if (result == null) {
                    result = currResult;
                }
            }
            ++n2;
        }
        return result;
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        return Iterables.concat((Iterable)Arrays.stream(this.childScopes).map(currScope -> currScope.getElements(name)).collect(Collectors.toList()));
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return Iterables.concat((Iterable)Arrays.stream(this.childScopes).map(currScope -> currScope.getElements(object)).collect(Collectors.toList()));
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return Iterables.concat((Iterable)Arrays.stream(this.childScopes).map(currScope -> currScope.getAllElements()).collect(Collectors.toList()));
    }
}

