/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit4.runner;

import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.ComparisonFailure;
import org.eclipse.jdt.internal.junit.runner.FailedComparison;
import org.eclipse.jdt.internal.junit.runner.IListensToTestExecutions;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.TestReferenceFailure;
import org.eclipse.jdt.internal.junit4.runner.JUnit4Identifier;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4TestListener
extends RunListener {
    private final IListensToTestExecutions fNotified;

    public JUnit4TestListener(IListensToTestExecutions notified) {
        this.fNotified = notified;
    }

    public void testStarted(Description plan) throws Exception {
        this.fNotified.notifyTestStarted(this.getIdentifier(plan, false, false));
    }

    public void testFailure(Failure failure) throws Exception {
        this.testFailure(failure, false);
    }

    public void testAssumptionFailure(Failure failure) {
        this.testFailure(failure, true);
    }

    private void testFailure(Failure failure, boolean assumptionFailed) {
        TestReferenceFailure testReferenceFailure;
        ITestIdentifier identifier = this.getIdentifier(failure.getDescription(), false, assumptionFailed);
        try {
            Throwable exception = failure.getException();
            String status = assumptionFailed || exception instanceof AssertionError ? "%FAILED " : "%ERROR  ";
            FailedComparison comparison = null;
            if (exception instanceof ComparisonFailure) {
                ComparisonFailure comparisonFailure = (ComparisonFailure)exception;
                comparison = new FailedComparison(comparisonFailure.getExpected(), comparisonFailure.getActual());
            } else if (exception instanceof org.junit.ComparisonFailure) {
                org.junit.ComparisonFailure comparisonFailure = (org.junit.ComparisonFailure)exception;
                comparison = new FailedComparison(comparisonFailure.getExpected(), comparisonFailure.getActual());
            }
            testReferenceFailure = new TestReferenceFailure(identifier, status, failure.getTrace(), comparison);
        }
        catch (RuntimeException e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            testReferenceFailure = new TestReferenceFailure(identifier, "%FAILED ", stringWriter.getBuffer().toString(), null);
        }
        this.fNotified.notifyTestFailed(testReferenceFailure);
    }

    public void testIgnored(Description plan) throws Exception {
        ITestIdentifier identifier = this.getIdentifier(plan, true, false);
        this.fNotified.notifyTestStarted(identifier);
        this.fNotified.notifyTestEnded(identifier);
    }

    public void testFinished(Description plan) throws Exception {
        this.fNotified.notifyTestEnded(this.getIdentifier(plan, false, false));
    }

    private ITestIdentifier getIdentifier(Description plan, boolean ignored, boolean assumptionFailed) {
        if (ignored) {
            return new IgnoredTestIdentifier(plan);
        }
        if (assumptionFailed) {
            return new AssumptionFailedTestIdentifier(plan);
        }
        return new JUnit4Identifier(plan);
    }

    private static class AssumptionFailedTestIdentifier
    extends JUnit4Identifier {
        public AssumptionFailedTestIdentifier(Description description) {
            super(description);
        }

        public String getName() {
            String name = super.getName();
            if (name != null) {
                return "@AssumptionFailure: " + name;
            }
            return null;
        }
    }

    private static class IgnoredTestIdentifier
    extends JUnit4Identifier {
        public IgnoredTestIdentifier(Description description) {
            super(description);
        }

        public String getName() {
            String name = super.getName();
            if (name != null) {
                return "@Ignore: " + name;
            }
            return null;
        }
    }
}

