/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.N4JSFlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.EdgeGuide;
import org.eclipse.n4js.flowgraphs.analysis.EdgeGuideMerged;
import org.eclipse.n4js.flowgraphs.analysis.EdgeGuideWorklist;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitorInternal;
import org.eclipse.n4js.flowgraphs.analysis.NextEdgesProvider;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;

public class GraphVisitorGuideInternal {
    private final N4JSFlowAnalyser flowAnalyzer;
    private final Collection<? extends GraphVisitorInternal> visitors;
    private final Set<Node> walkerVisitedNodes = new HashSet<Node>();
    private final EdgeGuideWorklist guideWorklist = new EdgeGuideWorklist();

    GraphVisitorGuideInternal(N4JSFlowAnalyser flowAnalyzer, Collection<? extends GraphVisitorInternal> visitors) {
        this.flowAnalyzer = flowAnalyzer;
        this.visitors = visitors;
    }

    void init() {
        for (GraphVisitorInternal graphVisitorInternal : this.visitors) {
            graphVisitorInternal.setFlowAnalyses(this.flowAnalyzer);
            graphVisitorInternal.callInitialize();
        }
    }

    void terminate() {
        for (GraphVisitorInternal graphVisitorInternal : this.visitors) {
            graphVisitorInternal.setFlowAnalyses(this.flowAnalyzer);
            graphVisitorInternal.callTerminate();
        }
    }

    void walkthroughForward(ComplexNode cn) {
        this.walkthrough(cn, TraverseDirection.Forward);
    }

    void walkthroughBackward(ComplexNode cn) {
        this.walkthrough(cn, TraverseDirection.Backward);
    }

    private void walkthrough(ComplexNode cn, TraverseDirection direction) {
        this.walkerVisitedNodes.clear();
        cn.getEntry().setReachable();
        cn.getExit().setReachable();
        for (GraphVisitorInternal graphVisitorInternal : this.visitors) {
            graphVisitorInternal.setFlowAnalyses(this.flowAnalyzer);
            graphVisitorInternal.setContainer(cn.getControlFlowContainer());
            graphVisitorInternal.callInitializeContainerInternal();
        }
        List<NextEdgesProvider> list = this.getEdgeProviders(direction);
        for (NextEdgesProvider nextEdgesProvider : list) {
            this.walkthrough(cn, nextEdgesProvider);
        }
        for (GraphVisitorInternal graphVisitorInternal : this.visitors) {
            graphVisitorInternal.callTerminateContainer();
        }
    }

    private List<NextEdgesProvider> getEdgeProviders(TraverseDirection mode) {
        LinkedList<NextEdgesProvider> edgeProviders = new LinkedList<NextEdgesProvider>();
        switch (mode) {
            case Forward: {
                edgeProviders.add(new NextEdgesProvider.Forward());
                break;
            }
            case Backward: {
                edgeProviders.add(new NextEdgesProvider.Backward());
            }
        }
        return edgeProviders;
    }

    private void walkthrough(ComplexNode cn, NextEdgesProvider edgeProvider) {
        List<BranchWalkerInternal> activatedPaths = this.initVisit();
        this.guideWorklist.initialize(cn, edgeProvider, activatedPaths);
        Node lastVisitNode = null;
        for (EdgeGuide currEdgeGuide : this.guideWorklist.getCurrentEdgeGuides()) {
            Node visitNode = currEdgeGuide.getPrevNode();
            this.visitNode(lastVisitNode, currEdgeGuide, visitNode);
            lastVisitNode = visitNode;
        }
        while (this.guideWorklist.hasNext()) {
            EdgeGuide currEdgeGuide;
            this.flowAnalyzer.checkCancelled();
            currEdgeGuide = this.guideWorklist.next();
            Node visitNode = currEdgeGuide.getNextNode();
            this.visitNode(lastVisitNode, currEdgeGuide, visitNode);
            lastVisitNode = visitNode;
            this.mergeEdgeGuides();
        }
    }

    private List<BranchWalkerInternal> initVisit() {
        LinkedList<BranchWalkerInternal> activatedPaths = new LinkedList<BranchWalkerInternal>();
        for (GraphVisitorInternal graphVisitorInternal : this.visitors) {
            activatedPaths.addAll(graphVisitorInternal.activateRequestedExplorers());
        }
        return activatedPaths;
    }

    private void mergeEdgeGuides() {
        List<EdgeGuide> joinGuideGroup = this.guideWorklist.getJoinGroups();
        if (!joinGuideGroup.isEmpty()) {
            EdgeGuide firstEG = joinGuideGroup.get(0);
            Node endNode = firstEG.getNextNode();
            for (EdgeGuide eg : joinGuideGroup) {
                Node startNode = eg.getPrevNode();
                this.callVisitOnEdge(startNode, eg, endNode);
            }
            EdgeGuideMerged mergedEG = this.guideWorklist.mergeJoinGroup(joinGuideGroup);
            this.callVisitOnNode(mergedEG, endNode);
        }
    }

    private Node visitNode(Node lastVisitNode, EdgeGuide currEdgeGuide, Node visitNode) {
        if (lastVisitNode != null) {
            this.callVisitOnEdge(lastVisitNode, currEdgeGuide, visitNode);
        }
        this.callVisitOnNode(currEdgeGuide, visitNode);
        return visitNode;
    }

    private void callVisitOnEdge(Node lastVisitNode, EdgeGuide currEdgeGuide, Node visitNode) {
        ControlFlowEdge egEdge = currEdgeGuide.getEdge();
        ControlFlowEdge visitedEdge = currEdgeGuide.getEdge();
        if (!this.guideWorklist.edgeVisited(egEdge)) {
            for (GraphVisitorInternal graphVisitorInternal : this.visitors) {
                graphVisitorInternal.callVisit(lastVisitNode, visitNode, visitedEdge);
            }
        }
        for (GraphVisitorInternal graphVisitorInternal : this.visitors) {
            List<BranchWalkerInternal> activatedPaths = graphVisitorInternal.activateRequestedExplorers();
            currEdgeGuide.addActiveBranches(activatedPaths);
        }
        Iterator<BranchWalkerInternal> iterator = currEdgeGuide.getBranchIterable().iterator();
        while (iterator.hasNext()) {
            BranchWalkerInternal branchWalker = iterator.next();
            branchWalker.callVisit(lastVisitNode, visitNode, visitedEdge);
            if (branchWalker.isActive()) continue;
            iterator.remove();
        }
    }

    private void callVisitOnNode(EdgeGuide currEdgeGuide, Node visitNode) {
        if (!this.walkerVisitedNodes.contains(visitNode)) {
            for (GraphVisitorInternal graphVisitorInternal : this.visitors) {
                graphVisitorInternal.callVisit(visitNode);
            }
        }
        this.walkerVisitedNodes.add(visitNode);
        for (GraphVisitorInternal graphVisitorInternal : this.visitors) {
            List<BranchWalkerInternal> activatedBranchWalkers = graphVisitorInternal.activateRequestedExplorers();
            currEdgeGuide.addActiveBranches(activatedBranchWalkers);
        }
        Iterator<BranchWalkerInternal> iterator = currEdgeGuide.getBranchIterable().iterator();
        while (iterator.hasNext()) {
            BranchWalkerInternal branchWalker = iterator.next();
            branchWalker.callVisit(visitNode);
            if (branchWalker.isActive()) continue;
            iterator.remove();
        }
    }
}

