/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.MethodDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.scoping.accessModifiers.MemberVisibilityChecker;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.AccessModifiers;
import org.eclipse.n4js.ts.types.util.MemberList;
import org.eclipse.n4js.ts.types.util.NameStaticPair;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.validation.validators.FindClassifierInHierarchyUtils;
import org.eclipse.n4js.validation.validators.utils.MemberCube;
import org.eclipse.n4js.validation.validators.utils.MemberMatrix;
import org.eclipse.n4js.validation.validators.utils.MemberRedefinitionUtils;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.Arrays;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class N4JSMemberRedefinitionValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private MemberVisibilityChecker memberVisibilityChecker;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;
    private static final String TYPE_VAR_CONTEXT = "TYPE_VAR_CONTEXT";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkMemberRedefinitions(N4ClassifierDefinition n4ClassifierDefinition) {
        boolean foundImpossibleExtendsImplements;
        if (!(n4ClassifierDefinition.getDefinedType() instanceof TClassifier)) {
            return;
        }
        TClassifier tClassifier = (TClassifier)n4ClassifierDefinition.getDefinedType();
        this.getContext().put(TClassifier.class, tClassifier);
        RuleEnvironment g = RuleEnvironmentExtensions.newRuleEnvironment((EObject)tClassifier);
        this.getContext().put(RuleEnvironment.class, g);
        ParameterizedTypeRef classTypeRef = TypeUtils.createTypeRef((Type)tClassifier, (TypeArgument[])new TypeArgument[0]);
        this.getContext().put(TYPE_VAR_CONTEXT, classTypeRef);
        MemberCube memberCube = this.createMemberValidationList();
        boolean isClass = tClassifier instanceof TClass;
        HashMap<ParameterizedTypeRef, MemberList<TMember>> nonAccessibleAbstractMembersBySuperTypeRef = new HashMap<ParameterizedTypeRef, MemberList<TMember>>();
        for (Map.Entry<NameStaticPair, MemberMatrix> entry : memberCube.entrySet()) {
            MemberMatrix mm = entry.getValue();
            HashSet<TMember> membersMissingOverrideAnnotation = new HashSet<TMember>();
            if (isClass) {
                this.constraints_67_MemberOverride_checkEntry(mm, membersMissingOverrideAnnotation);
            }
            if (mm.hasImplemented() && this.holdConstraints_68_Consumption(mm)) {
                this.constraints_69_Implementation(mm, membersMissingOverrideAnnotation);
            }
            this.constraints_60_InheritedConsumedCovariantSpecConstructor(tClassifier, mm);
            this.constraints_66_NonOverride(mm);
            this.constraints_42_45_46_AbstractMember(mm, nonAccessibleAbstractMembersBySuperTypeRef);
            this.unusedGenericTypeVariable(mm);
            this.checkUnpairedAccessorConsumption(mm, n4ClassifierDefinition);
            this.checkUnpairedAccessorFilling(mm, n4ClassifierDefinition);
            this.messageMissingOverrideAnnotation(mm, membersMissingOverrideAnnotation);
        }
        boolean bl = foundImpossibleExtendsImplements = !nonAccessibleAbstractMembersBySuperTypeRef.isEmpty();
        if (foundImpossibleExtendsImplements) {
            this.messageImpossibleExtendsImplements(n4ClassifierDefinition, nonAccessibleAbstractMembersBySuperTypeRef);
        }
        if (!foundImpossibleExtendsImplements) {
            this.constraints_41_AbstractClass(tClassifier, memberCube);
        }
    }

    private boolean constraints_60_InheritedConsumedCovariantSpecConstructor(TClassifier tClassifier, MemberMatrix mm) {
        boolean isValid = true;
        if (!mm.hasOwned()) {
            TMember firstImplemented;
            TMember firstInherited;
            TMember tMember = firstInherited = mm.hasInherited() ? mm.inherited().iterator().next() : null;
            if (firstInherited instanceof TMethod && firstInherited.isConstructor() && this.isCovarianceForConstructorsRequired((Type)tClassifier, firstInherited)) {
                isValid &= this.checkSpecConstructorOverrideCompatibility(tClassifier, (TMethod)firstInherited);
            }
            TMember tMember2 = firstImplemented = mm.hasImplemented() ? mm.implemented().iterator().next() : null;
            if (firstImplemented instanceof TMethod && firstImplemented.isConstructor() && this.isCovarianceForConstructorsRequired((Type)tClassifier, firstImplemented)) {
                isValid &= this.checkSpecConstructorOverrideCompatibility(tClassifier, (TMethod)firstImplemented);
            }
        }
        return isValid;
    }

    private boolean checkSpecConstructorOverrideCompatibility(TClassifier tClassifier, TMethod inheritedConstructor) {
        Type rightThisContext = MemberRedefinitionUtils.findThisContextForConstructor((Type)tClassifier, inheritedConstructor);
        Result subtypeResult = this.isSubTypeResult((TMember)inheritedConstructor, rightThisContext, (TMember)inheritedConstructor);
        if (subtypeResult.isFailure()) {
            String msg = IssueCodes.getMessageForCLF_PSEUDO_REDEFINED_SPEC_CTOR_INCOMPATIBLE(this.validatorMessageHelper.description((EObject)inheritedConstructor), this.validatorMessageHelper.description((EObject)tClassifier), this.validatorMessageHelper.description((EObject)rightThisContext));
            EObject astNode = tClassifier.getAstElement();
            this.addIssue(msg, astNode, (EStructuralFeature)N4JSPackage.eINSTANCE.getN4TypeDeclaration_Name(), "CLF_PSEUDO_REDEFINED_SPEC_CTOR_INCOMPATIBLE", new String[0]);
            return false;
        }
        return true;
    }

    private void checkUnpairedAccessorConsumption(MemberMatrix mm, N4ClassifierDefinition definition) {
        if (!mm.hasOwned() && mm.hasInherited() && mm.hasImplemented()) {
            boolean getterConsumed = false;
            boolean setterConsumed = false;
            TMember consumedAccessor = null;
            for (TMember implementedMember : mm.implemented()) {
                if (!implementedMember.isAccessor() || !mm.isConsumed(implementedMember)) continue;
                if (implementedMember.getMemberType() == MemberType.GETTER) {
                    getterConsumed = true;
                } else {
                    setterConsumed = true;
                }
                consumedAccessor = implementedMember;
            }
            if (getterConsumed != setterConsumed && mm.hasAccessorPair() && consumedAccessor != null) {
                this.messageMissingOwnedAccessorCorrespondingConsumedAccessor((FieldAccessor)consumedAccessor, definition);
            }
        }
    }

    private void checkUnpairedAccessorFilling(MemberMatrix mm, N4ClassifierDefinition definition) {
        if (definition.getDefinedType().isStaticPolyfill() && mm.hasMixedAccessorPair()) {
            FieldAccessor ownedAccessor = (FieldAccessor)Iterables.getFirst(mm.owned(), null);
            if (ownedAccessor == null) {
                return;
            }
            if (!(definition instanceof N4ClassDefinition)) {
                return;
            }
            TClass filledClass = MemberRedefinitionUtils.getFilledClass((N4ClassDefinition)definition);
            if (filledClass == null) {
                return;
            }
            MemberMatrix.ActuallyInheritedAndConsumedMembersIterator memberIterator = mm.actuallyInheritedAndMixedMembers();
            while (memberIterator.hasNext()) {
                TMember next = memberIterator.next();
                ContainerType containingType = next.getContainingType();
                if (containingType == filledClass) continue;
                this.messageMissingOwnedAccessor(ownedAccessor);
            }
        }
    }

    private boolean constraints_66_NonOverride(MemberMatrix mm) {
        if (mm.hasOwned()) {
            boolean bFoundWronglyDeclaredMember = false;
            for (TMember member : mm.owned()) {
                TMember m;
                if (!member.isDeclaredOverride() || (m = mm.possibleOverrideCandidateOrError(member)) != null) continue;
                bFoundWronglyDeclaredMember = true;
                if (member.isStatic() && mm.hasNonImplemented() && !mm.hasInherited() && !mm.hasImplemented()) {
                    TMember other = mm.nonImplemented().iterator().next();
                    String message = IssueCodes.getMessageForCLF_OVERRIDE_NON_EXISTENT_INTERFACE(this.validatorMessageHelper.description((EObject)member), this.validatorMessageHelper.description((EObject)other));
                    this.addIssue(message, member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_OVERRIDE_NON_EXISTENT_INTERFACE", new String[0]);
                    continue;
                }
                String message = IssueCodes.getMessageForCLF_OVERRIDE_NON_EXISTENT(this.keywordProvider.keyword(member), member.getName());
                this.addIssue(message, member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_OVERRIDE_NON_EXISTENT", new String[0]);
            }
            return bFoundWronglyDeclaredMember;
        }
        return true;
    }

    private void constraints_67_MemberOverride_checkEntry(MemberMatrix mm, Collection<TMember> membersMissingOverrideAnnotation) {
        for (TMember m : mm.owned()) {
            for (TMember s : mm.inherited()) {
                if (this.checkAccessibilityAndOverrideCompatibility(RedefinitionType.overridden, m, s, false, mm) != OverrideCompatibilityResult.COMPATIBLE) continue;
                if (s.isField() && m.isAccessor() && !mm.hasOwnedAccessorPair()) {
                    this.messageFieldOverrideNeedsAccessorPair(m, s);
                    continue;
                }
                if (m.isDeclaredOverride()) continue;
                membersMissingOverrideAnnotation.add(m);
            }
            if (!m.isAccessor() || !mm.hasMixedAccessorPair() || m.getContainingType().isStaticPolyfill()) continue;
            this.messageMissingOwnedAccessor((FieldAccessor)m);
        }
    }

    private boolean holdConstraints_68_Consumption(MemberMatrix mm) {
        TClassifier currentType = this.getCurrentClassifier();
        MemberList consumedMembers = new MemberList(2);
        for (TMember m : mm.implemented()) {
            boolean consume = true;
            MemberMatrix.SourceAwareIterator iter = mm.allMembers();
            while (iter.hasNext()) {
                TMember m_ = iter.next();
                if (m_ == m && iter.isInterfaceMember()) continue;
                if (m.isMethod() && !m_.isMethod() || !m.isMethod() && !m_.isAccessor() && !m_.isField()) {
                    if (iter.isInterfaceMember()) {
                        this.messageIncompatibleMembersToImplement(mm.implemented());
                        return false;
                    }
                    if (iter.isInheritedMember()) {
                        this.messageIncompatibleInheritedMembersToImplement(m_, mm.implemented());
                        return false;
                    }
                    return true;
                }
                boolean accessorPair = TypeUtils.isAccessorPair((TMember)m, (TMember)m_);
                if (accessorPair) continue;
                if (!m_.isAbstract() || m_.getContainingType() == currentType) {
                    consume = false;
                    break;
                }
                if (AccessModifiers.less((TMember)m, (TMember)m_)) {
                    consume = false;
                    break;
                }
                if (!m_.isSetter() && !this.isSubType(m, m_)) {
                    consume = false;
                    break;
                }
                if (!m_.isSetter() && !m_.isField() || this.isSubType(m_, m)) continue;
                consume = false;
                break;
            }
            if (!consume || consumedMembers.contains((Object)m)) continue;
            consumedMembers.add((Object)m);
        }
        mm.markConsumed((MemberList<TMember>)consumedMembers);
        return true;
    }

    private void constraints_69_Implementation(MemberMatrix mm, Collection<TMember> membersMissingOverrideAnnotation) {
        String missingAccessor = null;
        MemberList missingAccessors = new MemberList();
        MemberList conflictingMembers = new MemberList();
        TClassifier currentClassifier = this.getCurrentClassifier();
        HashSet<TMember> ownedErroneousMembers = null;
        for (TMember m : mm.implemented()) {
            if (mm.isConsumed(m)) continue;
            boolean bExistCompatibleMember = false;
            boolean bExistCompatibleGetter = false;
            boolean bExistCompatibleSetter = false;
            MemberMatrix.SourceAwareIterator iter = mm.ownedConsumedInheritedImplemented();
            while (iter.hasNext()) {
                TMember m_ = iter.next();
                if (ownedErroneousMembers != null && !iter.isOwnedMember()) break;
                if (m_ == m || ownedErroneousMembers != null && ownedErroneousMembers.contains(m_)) {
                    if (!iter.isInheritedMember()) continue;
                    bExistCompatibleMember = true;
                    continue;
                }
                OverrideCompatibilityResult compatibility = this.checkAccessibilityAndOverrideCompatibility(RedefinitionType.implemented, m_, m, !iter.isActualMember(), mm);
                if (compatibility == OverrideCompatibilityResult.ACCESSOR_PAIR) continue;
                if (compatibility == OverrideCompatibilityResult.ERROR) {
                    if (iter.isOwnedMember()) {
                        if (ownedErroneousMembers == null) {
                            ownedErroneousMembers = new HashSet<TMember>();
                        }
                        ownedErroneousMembers.add(m_);
                        continue;
                    }
                    if (!iter.isActualMember()) break;
                    return;
                }
                if (!iter.isActualMember()) continue;
                if (m.isField()) {
                    if (m_.isGetter()) {
                        bExistCompatibleGetter = true;
                    } else if (m_.isSetter()) {
                        bExistCompatibleSetter = true;
                    } else {
                        bExistCompatibleMember = true;
                    }
                } else {
                    bExistCompatibleMember = true;
                }
                if (m_.isDeclaredOverride() || m_.getContainingType() != currentClassifier) continue;
                membersMissingOverrideAnnotation.add(m_);
            }
            if (bExistCompatibleGetter != bExistCompatibleSetter) {
                missingAccessor = bExistCompatibleGetter ? "setter" : "getter";
                missingAccessors.add(m);
                continue;
            }
            if (bExistCompatibleMember || bExistCompatibleGetter && bExistCompatibleSetter) continue;
            conflictingMembers.add(m);
        }
        if (ownedErroneousMembers != null) {
            return;
        }
        if (!conflictingMembers.isEmpty()) {
            this.messageConflictingMixins((List<? extends TMember>)conflictingMembers);
        } else if (!missingAccessors.isEmpty()) {
            this.messageMissingAccessor(missingAccessor, (List<? extends TMember>)missingAccessors);
        }
    }

    private OverrideCompatibilityResult checkAccessibilityAndOverrideCompatibility(RedefinitionType redefinitionType, TMember m, TMember s, boolean consumptionConflict, MemberMatrix mm) {
        if (TypeUtils.isAccessorPair((TMember)m, (TMember)s)) {
            return OverrideCompatibilityResult.ACCESSOR_PAIR;
        }
        if (m.isConstructor() && s.isConstructor() && !this.isPolyfill(m) && !this.isCovarianceForConstructorsRequired(m, s)) {
            return OverrideCompatibilityResult.COMPATIBLE;
        }
        TModule contextModule = m.getContainingModule();
        ContainerType contextType = m.getContainingType();
        if (contextModule != null && contextType != null && !this.memberVisibilityChecker.isVisibleWhenOverriding(contextModule, (Type)contextType, (Type)contextType, s)) {
            if (!consumptionConflict) {
                this.messageOverrideNonAccessible(redefinitionType, m, s);
            }
            return OverrideCompatibilityResult.ERROR;
        }
        return this.constraints_65_overrideCompatible(redefinitionType, m, s, consumptionConflict, mm);
    }

    private OverrideCompatibilityResult constraints_65_overrideCompatible(RedefinitionType redefinitionType, TMember m, TMember s, boolean consumptionConflict, MemberMatrix mm) {
        Result result;
        Result result2;
        TField sF;
        boolean metaTypeCompatible = MemberRedefinitionUtils.isMetaTypeCompatible(m, s);
        if (!metaTypeCompatible) {
            if (!consumptionConflict) {
                this.messageOverrideMetaTypeIncompatible(redefinitionType, m, s, mm);
            }
            return OverrideCompatibilityResult.ERROR;
        }
        if (s.isFinal()) {
            if (!consumptionConflict) {
                this.messageOverrideFinal(redefinitionType, m, s);
            }
            return OverrideCompatibilityResult.ERROR;
        }
        boolean sIsField = s instanceof TField;
        boolean sIsSetter = s instanceof TSetter;
        boolean mIsField = m instanceof TField;
        if (sIsField && (sF = (TField)s).isConst() && (!mIsField || !((TField)m).isConst())) {
            if (!consumptionConflict) {
                this.messageOverrideConst(redefinitionType, m, sF);
            }
            return OverrideCompatibilityResult.ERROR;
        }
        if ((sIsField || sIsSetter) && !s.isFinal() && !s.isConst() && mIsField && (m.isFinal() || m.isConst())) {
            if (!consumptionConflict) {
                this.messageOverrideWithFinalOrConstField(redefinitionType, m, s);
            }
            return OverrideCompatibilityResult.ERROR;
        }
        if (m.isAbstract() && !s.isAbstract()) {
            if (!consumptionConflict) {
                this.messageOverrideAbstract(redefinitionType, m, s);
            }
            return OverrideCompatibilityResult.ERROR;
        }
        if (!m.isSetter() && !s.isSetter() && (result2 = this.isSubTypeResult(m, s)).isFailure()) {
            if (!consumptionConflict) {
                this.messageOverrideMemberTypeConflict(redefinitionType, m, s, result2, mm);
            }
            return OverrideCompatibilityResult.ERROR;
        }
        boolean sIsConst = false;
        if (sIsField) {
            sIsConst = ((TField)s).isConst();
        }
        if ((m.isSetter() || m.isField()) && !s.isGetter() && !sIsConst && (result = this.isSubTypeResult(s, m)).isFailure()) {
            if (!consumptionConflict) {
                this.messageOverrideMemberTypeConflict(redefinitionType, m, s, result, mm);
            }
            return OverrideCompatibilityResult.ERROR;
        }
        if (AccessModifiers.checkedLess((TMember)m, (TMember)s)) {
            if (!consumptionConflict) {
                this.messageOverrideAccessibilityReduced(redefinitionType, m, s);
            }
            return OverrideCompatibilityResult.ERROR;
        }
        MemberAccessModifier fixedLeft = AccessModifiers.fixed((TMember)m);
        MemberAccessModifier fixedRight = AccessModifiers.fixed((TMember)s);
        if (fixedLeft == MemberAccessModifier.PROTECTED && fixedRight == MemberAccessModifier.PUBLIC_INTERNAL || fixedLeft == MemberAccessModifier.PUBLIC_INTERNAL && fixedRight == MemberAccessModifier.PROTECTED) {
            this.messageOverrideAccessibilityReduced(redefinitionType, m, s);
            return OverrideCompatibilityResult.ERROR;
        }
        return OverrideCompatibilityResult.COMPATIBLE;
    }

    private boolean isPolyfill(TMember m) {
        ContainerType mContainer = m.getContainingType();
        return mContainer != null && mContainer.isPolyfill();
    }

    private boolean isCovarianceForConstructorsRequired(TMember m, TMember s) {
        return this.isCovarianceForConstructorsRequired((Type)m.getContainingType(), s);
    }

    private boolean isCovarianceForConstructorsRequired(Type baseType, TMember ctor) {
        TClass tSuperClass;
        if (ctor.getContainingType() instanceof TInterface) {
            return true;
        }
        return baseType instanceof TClass && (tSuperClass = ((TClass)baseType).getSuperClass()) != null && N4JSLanguageUtils.hasCovariantConstructor((TClassifier)tSuperClass);
    }

    private void constraints_42_45_46_AbstractMember(MemberMatrix mm, Map<ParameterizedTypeRef, MemberList<TMember>> nonAccessibleAbstractMembersBySuperTypeRef) {
        N4ClassifierDefinition classifierDefinition = this.getCurrentClassifierDefinition();
        TClassifier classifier = this.getCurrentClassifier();
        TModule contextModule = (TModule)EcoreUtil2.getContainerOfType((EObject)classifier, TModule.class);
        MemberMatrix.SourceAwareIterator iter = mm.allMembers();
        while (iter.hasNext()) {
            TMember m = iter.next();
            if (iter.isOwnedMember() || !m.isAbstract() || this.memberVisibilityChecker.isVisibleWhenOverriding(contextModule, (Type)classifier, (Type)classifier, m)) continue;
            Iterable<ParameterizedTypeRef> superTypeRefs = FindClassifierInHierarchyUtils.findSuperTypesWithMember(classifierDefinition, m);
            for (ParameterizedTypeRef superTypeRef : superTypeRefs) {
                MemberList nonAccessible = nonAccessibleAbstractMembersBySuperTypeRef.get(superTypeRef);
                if (nonAccessible == null) {
                    nonAccessible = new MemberList();
                    nonAccessibleAbstractMembersBySuperTypeRef.put(superTypeRef, (MemberList<TMember>)nonAccessible);
                }
                nonAccessible.add((Object)m);
            }
        }
    }

    private void unusedGenericTypeVariable(MemberMatrix mm) {
        for (TMember member : mm.owned()) {
            if (!(member instanceof TMethod)) continue;
            TMethod method = (TMethod)member;
            if (mm.hasInherited() || mm.hasImplemented()) continue;
            MethodDeclaration methodDeclaration = (MethodDeclaration)method.getAstElement();
            this.internalCheckNoUnusedTypeParameters(methodDeclaration);
        }
    }

    private boolean constraints_41_AbstractClass(TClassifier classifier, MemberCube memberCube) {
        ArrayList<TMember> abstractMembers = null;
        if (!classifier.isAbstract() && classifier instanceof TClass) {
            for (Map.Entry<NameStaticPair, MemberMatrix> entry : memberCube.entrySet()) {
                MemberMatrix mm = entry.getValue();
                MemberList l = new MemberList();
                Iterators.addAll((Collection)l, (Iterator)mm.actuallyInheritedAndMixedMembers());
                MemberMatrix.ActuallyInheritedAndConsumedMembersIterator iter = mm.actuallyInheritedAndMixedMembers();
                while (iter.hasNext()) {
                    TMember m = iter.next();
                    if (!m.isAbstract()) continue;
                    if (abstractMembers == null) {
                        abstractMembers = new ArrayList<TMember>();
                    }
                    abstractMembers.add(m);
                }
            }
        }
        if (abstractMembers != null) {
            this.messageMissingImplementations(abstractMembers);
            return false;
        }
        return true;
    }

    private void messageMissingImplementations(List<TMember> abstractMembers) {
        TClassifier classifier = this.getCurrentClassifier();
        if (!this.jsVariantHelper.allowMissingImplementation((EObject)classifier)) {
            String message = IssueCodes.getMessageForCLF_MISSING_IMPLEMENTATION(classifier.getName(), this.validatorMessageHelper.descriptions(abstractMembers));
            this.addIssue(message, "CLF_MISSING_IMPLEMENTATION");
        } else {
            String message = IssueCodes.getMessageForCLF_MISSING_IMPLEMENTATION_EXT(classifier.getName(), this.validatorMessageHelper.descriptions(abstractMembers));
            this.addIssue(message, "CLF_MISSING_IMPLEMENTATION_EXT");
        }
    }

    private void addIssue(String message, String issueCode) {
        N4ClassifierDefinition classifier = this.getCurrentClassifierDefinition();
        EStructuralFeature nameFeature = classifier.eClass().getEStructuralFeature("name");
        this.addIssue(message, (EObject)classifier, nameFeature, issueCode, new String[0]);
    }

    private void messageImpossibleExtendsImplements(N4ClassifierDefinition n4ClassifierDefinition, Map<ParameterizedTypeRef, MemberList<TMember>> nonAccessibleAbstractMembersBySuperTypeRef) {
        for (Map.Entry<ParameterizedTypeRef, MemberList<TMember>> entry : nonAccessibleAbstractMembersBySuperTypeRef.entrySet()) {
            ParameterizedTypeRef superTypeRef = entry.getKey();
            Type type = superTypeRef.getDeclaredType();
            String mode = type instanceof TInterface && !(n4ClassifierDefinition instanceof N4InterfaceDeclaration) ? "implement" : "extend";
            String message = IssueCodes.getMessageForCLF_NON_ACCESSIBLE_ABSTRACT_MEMBERS(mode, this.validatorMessageHelper.description((EObject)type), this.validatorMessageHelper.descriptions((Iterable)entry.getValue()));
            this.addIssue(message, superTypeRef.eContainer(), superTypeRef.eContainingFeature(), "CLF_NON_ACCESSIBLE_ABSTRACT_MEMBERS", new String[0]);
        }
    }

    private void messageMissingOverrideAnnotation(MemberMatrix mm, Collection<TMember> missingOverrideAnnotationMembers) {
        if (mm.hasOwned() && missingOverrideAnnotationMembers.size() > 0) {
            Iterable overriddenMembers = Iterables.concat(mm.inherited(), mm.implemented());
            for (TMember overriding : mm.owned()) {
                if (!missingOverrideAnnotationMembers.contains(overriding) || overriding.isConstructor() || !this.jsVariantHelper.checkOverrideAnnotation((EObject)overriding)) continue;
                Iterable<TMember> filteredOverriddenMembers = MemberRedefinitionUtils.getMetatypeCompatibleOverriddenMembers(overriding, overriddenMembers);
                String redefinitionVerb = MemberRedefinitionUtils.getRedefinitionVerb(filteredOverriddenMembers, this.getCurrentClassifier());
                String message = IssueCodes.getMessageForCLF_OVERRIDE_ANNOTATION(this.validatorMessageHelper.descriptionDifferentFrom(overriding, overriddenMembers), redefinitionVerb, this.validatorMessageHelper.descriptions(filteredOverriddenMembers));
                this.addIssue(message, overriding.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_OVERRIDE_ANNOTATION", new String[0]);
            }
        }
    }

    private void messageFieldOverrideNeedsAccessorPair(TMember overriding, TMember overridden) {
        if (overriding.getContainingType() != this.getCurrentClassifier()) {
            throw new IllegalStateException("must not happen as member is not consumed");
        }
        String missingAccessor = overriding.isGetter() ? "setter" : "getter";
        String message = IssueCodes.getMessageForCLF_OVERRIDE_FIELD_REQUIRES_ACCESSOR_PAIR(this.validatorMessageHelper.descriptionDifferentFrom(overriding, overridden), this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding), missingAccessor);
        this.addIssue(message, overriding.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_OVERRIDE_FIELD_REQUIRES_ACCESSOR_PAIR", new String[0]);
    }

    private void messageOverrideMemberTypeConflict(RedefinitionType redefinitionType, TMember overriding, TMember overridden, Result result, MemberMatrix mm) {
        String message;
        String code;
        String redefinitionTypeName = redefinitionType.name();
        if (redefinitionType == RedefinitionType.implemented && Iterables.contains(mm.implemented(), (Object)overriding)) {
            redefinitionTypeName = "consumed";
        }
        String overridingSource = "";
        if (redefinitionType == RedefinitionType.implemented && Iterables.contains(mm.inherited(), (Object)overriding)) {
            overridingSource = "inherited ";
        }
        String extraMessage = this.cfOtherImplementedMembers(mm, overriding, overridden);
        if (overriding.isField() && overridden.isField() && !((TField)overridden).isConst()) {
            code = "CLF_REDEFINED_TYPE_NOT_SAME_TYPE";
            message = IssueCodes.getMessageForCLF_REDEFINED_TYPE_NOT_SAME_TYPE(String.valueOf(overridingSource) + this.validatorMessageHelper.descriptionDifferentFrom(overriding, overridden), redefinitionTypeName, this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding), extraMessage);
        } else if (overriding.isMethod() && overridden.isMethod()) {
            code = "CLF_REDEFINED_METHOD_TYPE_CONFLICT";
            message = IssueCodes.getMessageForCLF_REDEFINED_METHOD_TYPE_CONFLICT(String.valueOf(overridingSource) + this.validatorMessageHelper.descriptionDifferentFrom(overriding, overridden), redefinitionTypeName, this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding), this.validatorMessageHelper.trimTypesystemMessage(result), extraMessage);
        } else {
            code = "CLF_REDEFINED_MEMBER_TYPE_INVALID";
            message = IssueCodes.getMessageForCLF_REDEFINED_MEMBER_TYPE_INVALID(String.valueOf(overridingSource) + this.validatorMessageHelper.descriptionDifferentFrom(overriding, overridden), this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding), redefinitionTypeName, this.validatorMessageHelper.trimTypesystemMessage(result), extraMessage);
        }
        this.addIssueToMemberOrInterfaceReference(redefinitionType, overriding, overridden, message, code, new String[0]);
    }

    private void messageOverrideAbstract(RedefinitionType redefinitionType, TMember overriding, TMember overridden) {
        String message = IssueCodes.getMessageForCLF_OVERRIDEN_CONCRETE_WITH_ABSTRACT(this.validatorMessageHelper.descriptionDifferentFrom(overriding, overridden), this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding));
        this.addIssueToMemberOrInterfaceReference(redefinitionType, overriding, overridden, message, "CLF_OVERRIDEN_CONCRETE_WITH_ABSTRACT", new String[0]);
    }

    private void messageOverrideAccessibilityReduced(RedefinitionType redefinitionType, TMember overriding, TMember overridden) {
        String message = IssueCodes.getMessageForCLF_OVERRIDE_VISIBILITY(this.validatorMessageHelper.descriptionDifferentFrom(overriding, overridden), this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding));
        this.addIssueToMemberOrInterfaceReference(redefinitionType, overriding, overridden, message, "CLF_OVERRIDE_VISIBILITY", "org.eclipse.n4js.validation.validators.N4JSMemberRedefinitationValidator.overridden_member_modifier", overridden.getMemberAccessModifier().getName(), "org.eclipse.n4js.validation.validators.N4JSMemberRedefinitationValidator.overridden_member_name", overridden.getName(), "org.eclipse.n4js.validation.validators.N4JSMemberRedefinitationValidator.super_class_name", overridden.getContainingType().getName());
    }

    private void messageOverrideNonAccessible(RedefinitionType redefinitionType, TMember overriding, TMember overridden) {
        String message = IssueCodes.getMessageForCLF_REDEFINED_NON_ACCESSIBLE(this.validatorMessageHelper.descriptionDifferentFrom(overriding, overridden), this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding));
        this.addIssue(message, overriding.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_REDEFINED_NON_ACCESSIBLE", new String[0]);
    }

    private void messageOverrideFinal(RedefinitionType redefinitionType, TMember overriding, TMember overridden) {
        String message = IssueCodes.getMessageForCLF_OVERRIDE_FINAL(this.validatorMessageHelper.descriptionDifferentFrom(overriding, overridden), this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding));
        this.addIssueToMemberOrInterfaceReference(redefinitionType, overriding, overridden, message, "CLF_OVERRIDE_FINAL", "org.eclipse.n4js.validation.validators.N4JSMemberRedefinitionValidator.overridden_member_uri", EcoreUtil.getURI((EObject)overridden).toString());
    }

    private void messageOverrideWithFinalOrConstField(RedefinitionType redefinitionType, TMember overriding, TMember overridden) {
        String badModifier = overriding.isConst() ? "const" : "final";
        String prefix = overridden instanceof TField ? "non-" + badModifier + " " : "";
        String message = IssueCodes.getMessageForCLF_OVERRIDE_WITH_FINAL_OR_CONST_FIELD(String.valueOf(prefix) + this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding), badModifier);
        this.addIssueToMemberOrInterfaceReference(redefinitionType, overriding, overridden, message, "CLF_OVERRIDE_WITH_FINAL_OR_CONST_FIELD", new String[0]);
    }

    private void messageOverrideConst(RedefinitionType redefinitionType, TMember overriding, TField overridden) {
        String message = IssueCodes.getMessageForCLF_OVERRIDE_CONST(this.validatorMessageHelper.descriptionDifferentFrom(overriding, (TMember)overridden), this.validatorMessageHelper.descriptionDifferentFrom((TMember)overridden, overriding));
        this.addIssueToMemberOrInterfaceReference(redefinitionType, overriding, (TMember)overridden, message, "CLF_OVERRIDE_CONST", new String[0]);
    }

    private void messageOverrideMetaTypeIncompatible(RedefinitionType redefinitionType, TMember overriding, TMember overridden, MemberMatrix mm) {
        if (redefinitionType == RedefinitionType.overridden) {
            String message = IssueCodes.getMessageForCLF_OVERRIDE_MEMBERTYPE_INCOMPATIBLE(this.validatorMessageHelper.descriptionDifferentFrom(overriding, overridden), this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding));
            this.addIssueToMemberOrInterfaceReference(redefinitionType, overriding, overridden, message, "CLF_OVERRIDE_MEMBERTYPE_INCOMPATIBLE", new String[0]);
        } else {
            String message = IssueCodes.getMessageForCLF_IMPLEMENT_MEMBERTYPE_INCOMPATIBLE(this.validatorMessageHelper.descriptionDifferentFrom(overriding, overridden), this.validatorMessageHelper.descriptionDifferentFrom(overridden, overriding), this.cfOtherImplementedMembers(mm, overridden));
            this.addIssueToMemberOrInterfaceReference(redefinitionType, overriding, overridden, message, "CLF_IMPLEMENT_MEMBERTYPE_INCOMPATIBLE", new String[0]);
        }
    }

    private String cfOtherImplementedMembers(MemberMatrix mm, TMember ... filteredMembers) {
        String others = this.validatorMessageHelper.descriptions(StreamSupport.stream(mm.implemented().spliterator(), false).filter(m -> !Arrays.contains((Object[])filteredMembers, (Object)m)).collect(Collectors.toList()));
        if (others.length() == 0) {
            return "";
        }
        return " Also cf. " + others + ".";
    }

    private void messageIncompatibleMembersToImplement(Iterable<TMember> implementedMembers) {
        String message = IssueCodes.getMessageForCLF_CONSUMED_MEMBER_UNSOLVABLE_CONFLICT(this.validatorMessageHelper.descriptions(implementedMembers));
        this.addIssue(message, "CLF_CONSUMED_MEMBER_UNSOLVABLE_CONFLICT");
    }

    private void messageIncompatibleInheritedMembersToImplement(TMember inheritedMember, Iterable<TMember> implementedMembers) {
        String message = IssueCodes.getMessageForCLF_CONSUMED_INHERITED_MEMBER_UNSOLVABLE_CONFLICT(this.validatorMessageHelper.description((EObject)inheritedMember), this.validatorMessageHelper.descriptions(implementedMembers));
        this.addIssue(message, "CLF_CONSUMED_INHERITED_MEMBER_UNSOLVABLE_CONFLICT");
    }

    private void messageConflictingMixins(List<? extends TMember> conflictingMembers) {
        String message = IssueCodes.getMessageForCLF_CONSUMED_MEMBER_SOLVABLE_CONFLICT(this.validatorMessageHelper.descriptions(conflictingMembers));
        this.addIssue(message, "CLF_CONSUMED_MEMBER_SOLVABLE_CONFLICT");
    }

    private void messageMissingAccessor(String missingAccessor, List<? extends TMember> conflictingMembers) {
        String message = IssueCodes.getMessageForCLF_CONSUMED_FIELD_ACCESSOR_PAIR_INCOMPLETE(missingAccessor, this.validatorMessageHelper.descriptions(conflictingMembers));
        this.addIssue(message, "CLF_CONSUMED_FIELD_ACCESSOR_PAIR_INCOMPLETE");
    }

    private void messageMissingOwnedAccessor(FieldAccessor accessor) {
        String counterpartDescription;
        String accessorDescription = Strings.toFirstUpper((String)this.validatorMessageHelper.description((EObject)accessor));
        String verb = accessor.getContainingType().isStaticPolyfill() ? "filled" : "declared";
        verb = accessor.isDeclaredOverride() ? "overridden" : verb;
        String string = counterpartDescription = accessor instanceof TSetter ? "getter" : "setter";
        if (this.jsVariantHelper.isN4JSMode((EObject)accessor) || this.jsVariantHelper.isExternalMode((EObject)accessor)) {
            this.messageMissingOwnedAccessorN4JS(accessorDescription, verb, counterpartDescription, accessor);
        } else {
            this.messageMissingOwnedAccessorJS(accessorDescription, verb, counterpartDescription, accessor);
        }
    }

    private void messageMissingOwnedAccessorN4JS(String accessorDescription, String verb, String counterpartDescription, FieldAccessor accessor) {
        String message = IssueCodes.getMessageForCLF_UNMATCHED_ACCESSOR_OVERRIDE(accessorDescription, verb, counterpartDescription);
        this.addIssue(message, accessor.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_UNMATCHED_ACCESSOR_OVERRIDE", new String[0]);
    }

    private void messageMissingOwnedAccessorJS(String accessorDescription, String verb, String counterpartDescription, FieldAccessor accessor) {
        String message = IssueCodes.getMessageForCLF_UNMATCHED_ACCESSOR_OVERRIDE_JS(accessorDescription, verb, counterpartDescription);
        this.addIssue(message, accessor.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_UNMATCHED_ACCESSOR_OVERRIDE_JS", new String[0]);
    }

    private void messageMissingOwnedAccessorCorrespondingConsumedAccessor(FieldAccessor accessor, N4ClassifierDefinition definition) {
        String message = IssueCodes.getMessageForCLF_UNMATCHED_ACCESSOR_OVERRIDE(Strings.toFirstUpper((String)this.validatorMessageHelper.description((EObject)accessor)), "consumed", accessor instanceof TSetter ? "getter" : "setter");
        this.addIssue(message, (EObject)definition, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "CLF_UNMATCHED_ACCESSOR_OVERRIDE", new String[0]);
    }

    private void addIssueToMemberOrInterfaceReference(RedefinitionType redefinitionType, TMember overriding, TMember implemented, String message, String issueCode, String ... issueData) {
        if (redefinitionType == RedefinitionType.overridden && overriding.getContainingType() != this.getCurrentClassifier()) {
            throw new IllegalStateException("must not happen as member is not consumed");
        }
        TClassifier currentClassifier = this.getCurrentClassifier();
        if (overriding.getContainingType() == currentClassifier) {
            this.addIssue(message, overriding.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, issueCode, issueData);
        } else {
            ContainerTypesHelper.MemberCollector memberCollector = this.containerTypesHelper.fromContext((EObject)this.getCurrentClassifierDefinition());
            ContainerType<?> bequestingType = memberCollector.directSuperTypeBequestingMember(currentClassifier, implemented);
            Optional<ParameterizedTypeRef> optRef = StreamSupport.stream(this.getCurrentClassifierDefinition().getImplementedOrExtendedInterfaceRefs().spliterator(), false).filter(ref -> ref.getDeclaredType() == bequestingType).findAny();
            ParameterizedTypeRef ref2 = optRef.get();
            EStructuralFeature feature = ref2.eContainingFeature();
            List list = (List)this.getCurrentClassifierDefinition().eGet(feature);
            int index = list.indexOf(ref2);
            this.addIssue(message, (EObject)this.getCurrentClassifierDefinition(), feature, index, issueCode, issueData);
        }
    }

    private boolean isSubType(TMember left, TMember right) {
        return this.isSubTypeResult(left, right).isSuccess();
    }

    private Result isSubTypeResult(TMember left, TMember right) {
        Type rightThisContext = left.isConstructor() && right.isConstructor() && !this.isPolyfill(left) ? MemberRedefinitionUtils.findThisContextForConstructor((Type)left.getContainingType(), (TMethod)right) : null;
        return this.isSubTypeResult(left, rightThisContext, right);
    }

    private Result isSubTypeResult(TMember left, Type rightThisContextType, TMember right) {
        Resource res = left.eResource();
        ParameterizedTypeRef mainContext = this.getCurrentTypeContext();
        ParameterizedTypeRef rightThisContext = rightThisContextType != null ? TypeUtils.createTypeRef((Type)rightThisContextType, (TypeArgument[])new TypeArgument[0]) : mainContext;
        RuleEnvironment G_left = this.ts.createRuleEnvironmentForContext((TypeRef)mainContext, (TypeRef)mainContext, res);
        RuleEnvironment G_right = this.ts.createRuleEnvironmentForContext((TypeRef)mainContext, (TypeRef)rightThisContext, res);
        TypeRef typeLeft = this.ts.tau((TypableElement)left, G_left);
        TypeRef typeRight = this.ts.tau((TypableElement)right, G_right);
        RuleEnvironment G = this.getCurrentRuleEnvironment();
        if (left.isConstructor() && typeLeft instanceof FunctionTypeExprOrRef) {
            typeLeft = TypeUtils.createFunctionTypeExpression(null, Collections.emptyList(), (List)((FunctionTypeExprOrRef)typeLeft).getFpars(), null);
        }
        if (right.isConstructor() && typeRight instanceof FunctionTypeExprOrRef) {
            typeRight = TypeUtils.createFunctionTypeExpression(null, Collections.emptyList(), (List)((FunctionTypeExprOrRef)typeRight).getFpars(), null);
        }
        return this.ts.subtype(G, (TypeArgument)typeLeft, (TypeArgument)typeRight);
    }

    private TClassifier getCurrentClassifier() {
        return (TClassifier)this.getContext().get(TClassifier.class);
    }

    private N4ClassifierDefinition getCurrentClassifierDefinition() {
        return (N4ClassifierDefinition)this.getCurrentObject();
    }

    private RuleEnvironment getCurrentRuleEnvironment() {
        return (RuleEnvironment)this.getContext().get(RuleEnvironment.class);
    }

    private ParameterizedTypeRef getCurrentTypeContext() {
        return (ParameterizedTypeRef)this.getContext().get(TYPE_VAR_CONTEXT);
    }

    private MemberCube createMemberValidationList() {
        ContainerTypesHelper.MemberCollector memberCollector = this.containerTypesHelper.fromContext((EObject)this.getCurrentClassifierDefinition());
        TClassifier tClassifier = this.getCurrentClassifier();
        return new MemberCube(tClassifier, memberCollector);
    }

    private static enum OverrideCompatibilityResult {
        COMPATIBLE,
        ERROR,
        ACCESSOR_PAIR;

    }

    private static enum RedefinitionType {
        overridden,
        implemented;

    }
}

