/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberAnnotationList;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.VoidType;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.validation.validators.LazyOverrideAwareMemberCollector;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class N4JSMemberValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;
    private static final List<AnnotationDefinition> ANNOTATIONS_REQUIRE_TEST = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new AnnotationDefinition[]{AnnotationDefinition.TEST_FIXME, AnnotationDefinition.TEST_IGNORE}));

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkN4MemberDeclaration(N4MemberDeclaration n4Member) {
        if (n4Member instanceof N4MemberAnnotationList) {
            return;
        }
        TMember it = n4Member.getDefinedTypeElement();
        if (it == null) {
            return;
        }
        this.internalCheckNameStartsWithDollar(it);
        this.internalCheckAbstractAndFinal(it);
        this.internalCheckPrivateOrProjectWithInternalAnnotation(n4Member, it);
    }

    @Check
    public void checkComputedPropertyName(PropertyNameOwner owner) {
        String name;
        boolean _hasComputedPropertyName = owner.hasComputedPropertyName();
        if (_hasComputedPropertyName && (name = owner.getName()) != null) {
            boolean _not;
            boolean _isValidName = owner.isValidName();
            boolean bl = _not = !_isValidName;
            if (_not) {
                String message = IssueCodes.getMessageForAST_RESERVED_IDENTIFIER(name);
                this.addIssue(message, (EObject)owner, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "AST_RESERVED_IDENTIFIER", new String[0]);
            }
        }
    }

    @Check
    public void checkN4FieldDeclaration(N4FieldDeclaration n4Field) {
        if (n4Field instanceof N4MemberAnnotationList) {
            return;
        }
        TMember member = n4Field.getDefinedTypeElement();
        if (member == null) {
            return;
        }
        this.holdsMinimalMemberAccessModifier(member);
    }

    @Check
    public void checkN4MethodDeclaration(N4MethodDeclaration n4Method) {
        boolean _tripleEquals;
        if (n4Method instanceof N4MemberAnnotationList) {
            return;
        }
        this.holdsCallableConstructorConstraints(n4Method);
        TMember _definedTypeElement = n4Method.getDefinedTypeElement();
        boolean bl = _tripleEquals = _definedTypeElement == null;
        if (_tripleEquals) {
            return;
        }
        TMember _definedTypeElement_1 = n4Method.getDefinedTypeElement();
        TMethod tmethod = (TMethod)_definedTypeElement_1;
        this.holdsAbstractAndBodyPropertiesOfMethod((TMember)tmethod);
        this.holdsConstructorConstraints(tmethod);
    }

    @Check
    public void checkN4GetterDeclaration(N4GetterDeclaration n4Getter) {
        boolean _tripleEquals;
        if (n4Getter instanceof N4MemberAnnotationList) {
            return;
        }
        TGetter _definedGetter = n4Getter.getDefinedGetter();
        boolean bl = _tripleEquals = _definedGetter == null;
        if (_tripleEquals) {
            return;
        }
        TGetter it = n4Getter.getDefinedGetter();
        this.holdsAbstractAndBodyPropertiesOfMethod((TMember)it);
        this.internalCheckGetterType(n4Getter);
    }

    @Check
    public void checkN4SetterDeclaration(N4SetterDeclaration n4Setter) {
        boolean _tripleEquals;
        if (n4Setter instanceof N4MemberAnnotationList) {
            return;
        }
        TSetter _definedSetter = n4Setter.getDefinedSetter();
        boolean bl = _tripleEquals = _definedSetter == null;
        if (_tripleEquals) {
            return;
        }
        TSetter it = n4Setter.getDefinedSetter();
        this.holdsAbstractAndBodyPropertiesOfMethod((TMember)it);
    }

    @Check
    public void checkN4StructuralWithOnTypeVariables(ParameterizedTypeRefStructural ptrs) {
        boolean _not;
        Type _declaredType = ptrs.getDeclaredType();
        boolean bl = _not = !(_declaredType instanceof TypeVariable);
        if (_not) {
            return;
        }
        EList _astStructuralMembers = ptrs.getAstStructuralMembers();
        for (TStructMember sm : _astStructuralMembers) {
            String message = IssueCodes.getMessageForTYS_ADDITIONAL_STRUCTURAL_MEMBERS_ON_TYPE_VARS();
            this.addIssue(message, (EObject)sm, "TYS_ADDITIONAL_STRUCTURAL_MEMBERS_ON_TYPE_VARS");
        }
    }

    public boolean holdsAbstractAndBodyPropertiesOfMethod(TMember accessorOrMethod) {
        return this.holdsAbstractOrHasBody(accessorOrMethod) && this.holdsAbstractMethodMustHaveNoBody(accessorOrMethod) && this.holdsAbstractMethodMustNotBeStatic(accessorOrMethod) && this.holdsAbstractMemberContainedInAbstractClassifier(accessorOrMethod) && this.holdsMinimalMemberAccessModifier(accessorOrMethod);
    }

    private void internalCheckNameStartsWithDollar(TMember member) {
        String name;
        boolean _not;
        boolean _requireCheckNameStartsWithDollar = this.jsVariantHelper.requireCheckNameStartsWithDollar((EObject)member);
        boolean bl = _not = !_requireCheckNameStartsWithDollar;
        if (_not) {
            return;
        }
        String _name = null;
        if (member != null) {
            _name = member.getName();
        }
        if ((name = _name) != null && name.startsWith("$")) {
            String message = IssueCodes.getMessageForCLF_NAME_DOLLAR();
            this.addIssue(message, member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_NAME_DOLLAR", new String[0]);
        }
    }

    private void internalCheckAbstractAndFinal(TMember member) {
        boolean _isFinal = member.isFinal();
        if (_isFinal) {
            boolean _isAbstract = member.isAbstract();
            if (_isAbstract) {
                String message = IssueCodes.getMessageForCLF_ABSTRACT_FINAL(this.keywordProvider.keyword(member));
                this.addIssue(message, member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_ABSTRACT_FINAL", new String[0]);
            } else if (member.getContainingType() instanceof TInterface && !(member instanceof TMethod)) {
                String message_1 = IssueCodes.getMessageForCLF_NO_FINAL_INTERFACE_MEMBER();
                this.addIssue(message_1, member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_NO_FINAL_INTERFACE_MEMBER", new String[0]);
            }
        }
    }

    private boolean holdsConstructorConstraints(TMethod method) {
        boolean _isConstructor = method.isConstructor();
        if (_isConstructor) {
            boolean _not_3;
            boolean _not_2;
            boolean _not_1;
            boolean _not;
            boolean _holdsConstructorInInterfaceDoesNotHaveBody = this.holdsConstructorInInterfaceDoesNotHaveBody(method);
            boolean bl = _not = !_holdsConstructorInInterfaceDoesNotHaveBody;
            if (_not) {
                return false;
            }
            boolean _holdsConstructorInInterfaceRequiresCovarianceAnnotation = this.holdsConstructorInInterfaceRequiresCovarianceAnnotation(method);
            boolean bl2 = _not_1 = !_holdsConstructorInInterfaceRequiresCovarianceAnnotation;
            if (_not_1) {
                return false;
            }
            boolean _holdsConstructorNoReturnType = this.holdsConstructorNoReturnType(method);
            boolean bl3 = _not_2 = !_holdsConstructorNoReturnType;
            if (_not_2) {
                return false;
            }
            boolean _holdsConstructorNoTypeParameters = this.holdsConstructorNoTypeParameters(method);
            boolean bl4 = _not_3 = !_holdsConstructorNoTypeParameters;
            if (_not_3) {
                return false;
            }
            boolean result = this.holdsConstructorModifiers(method);
            return this.holdsRequiredExplicitSuperCallIsFound(method) && result;
        }
        return true;
    }

    private boolean holdsConstructorModifiers(TMethod constructor) {
        if (constructor.isAbstract() && !(constructor.getContainingType() instanceof TInterface) || constructor.isStatic() || constructor.isFinal() || this.getHasIllegalOverride(constructor)) {
            String message = IssueCodes.getMessageForCLF_CTOR_ILLEGAL_MODIFIER();
            this.addIssue(message, constructor.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_CTOR_ILLEGAL_MODIFIER", new String[0]);
            return false;
        }
        return true;
    }

    private boolean getHasIllegalOverride(TMethod constructor) {
        return !constructor.getContainingType().isStaticPolyfill() && AnnotationDefinition.OVERRIDE.hasAnnotation((AnnotableElement)((N4MethodDeclaration)constructor.getAstElement()));
    }

    private boolean holdsConstructorInInterfaceDoesNotHaveBody(TMethod constructor) {
        if (constructor.getContainingType() instanceof TInterface && !constructor.isHasNoBody()) {
            this.addIssue(IssueCodes.getMessageForITF_CONSTRUCTOR_BODY(), constructor.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "ITF_CONSTRUCTOR_BODY", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsConstructorInInterfaceRequiresCovarianceAnnotation(TMethod constructor) {
        ContainerType container = constructor.getContainingType();
        if (container instanceof TInterface && !N4JSLanguageUtils.hasCovariantConstructor((TClassifier)((TInterface)container))) {
            this.addIssue(IssueCodes.getMessageForITF_CONSTRUCTOR_COVARIANCE(), constructor.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "ITF_CONSTRUCTOR_COVARIANCE", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsConstructorNoReturnType(TMethod constructor) {
        boolean _tripleNotEquals;
        EObject _astElement = constructor.getAstElement();
        N4MethodDeclaration constructorDecl = (N4MethodDeclaration)_astElement;
        TypeRef _returnTypeRef = constructorDecl.getReturnTypeRef();
        boolean bl = _tripleNotEquals = _returnTypeRef != null;
        if (_tripleNotEquals) {
            this.addIssue(IssueCodes.getMessageForCLF_CTOR_RETURN_TYPE(), (EObject)constructorDecl, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__RETURN_TYPE_REF, "CLF_CTOR_RETURN_TYPE", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsConstructorNoTypeParameters(TMethod method) {
        boolean _isEmpty = method.getTypeVars().isEmpty();
        if (_isEmpty) {
            return true;
        }
        EObject _astElement = method.getAstElement();
        N4MethodDeclaration constructorDecl = (N4MethodDeclaration)_astElement;
        Pair<Integer, Integer> offsetLength = this.findTypeVariablesOffset((GenericDeclaration)constructorDecl);
        this.addIssue(IssueCodes.getMessageForCLF_CTOR_NO_TYPE_PARAMETERS(), (EObject)constructorDecl, (Integer)offsetLength.getKey(), (Integer)offsetLength.getValue(), "CLF_CTOR_NO_TYPE_PARAMETERS");
        return false;
    }

    private Pair<Integer, Integer> findTypeVariablesOffset(GenericDeclaration genericDeclaration) {
        boolean _isEmpty = genericDeclaration.getTypeVars().isEmpty();
        if (_isEmpty) {
            throw new IllegalArgumentException("Cannot determine offset of type variables for a GenericDeclaration without any type variables.");
        }
        List typeVariableNodes = NodeModelUtils.findNodesForFeature((EObject)genericDeclaration, (EStructuralFeature)N4JSPackage.Literals.GENERIC_DECLARATION__TYPE_VARS);
        INode firstTypeVariable = (INode)typeVariableNodes.get(0);
        INode lastTypeVariable = (INode)IterableExtensions.last((Iterable)typeVariableNodes);
        int _offset = firstTypeVariable.getOffset();
        int _offset_1 = lastTypeVariable.getOffset();
        int _length = lastTypeVariable.getLength();
        int _plus = _offset_1 + _length;
        int _offset_2 = firstTypeVariable.getOffset();
        int _minus = _plus - _offset_2;
        return Pair.of((Object)_offset, (Object)_minus);
    }

    private boolean holdsRequiredExplicitSuperCallIsFound(TMethod constructor) {
        EObject type;
        boolean _tripleNotEquals;
        EObject _astElement = constructor.getAstElement();
        Block _body = this.getBody((N4MemberDeclaration)_astElement);
        boolean bl = _tripleNotEquals = _body != null;
        if (_tripleNotEquals && (type = constructor.eContainer()) instanceof TClass) {
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)constructor);
            TClassifier superClass = RuleEnvironmentExtensions.getDeclaredOrImplicitSuperType(G, (TClass)type);
            TMethod ctor = this.containerTypesHelper.fromContext((EObject)constructor).findConstructor((ContainerType<?>)superClass);
            if (ctor != null && ctor != RuleEnvironmentExtensions.objectType(G).getOwnedCtor()) {
                EObject _astElement_1;
                boolean existsSuperCall;
                boolean _greaterThan;
                int _size = ctor.getFpars().size();
                boolean bl2 = _greaterThan = _size > 0;
                if (_greaterThan && !(existsSuperCall = ((N4MethodDeclaration)(_astElement_1 = constructor.getAstElement())).existsExplicitSuperCall())) {
                    EObject _eContainer = ctor.eContainer();
                    String className = ((IdentifiableElement)_eContainer).getName();
                    this.addIssue(IssueCodes.getMessageForKEY_SUP_REQUIRE_EXPLICIT_SUPERCTOR_CALL(className), constructor.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "KEY_SUP_REQUIRE_EXPLICIT_SUPERCTOR_CALL", new String[0]);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean holdsCallableConstructorConstraints(N4MethodDeclaration method) {
        boolean _isCallableConstructor = method.isCallableConstructor();
        if (_isCallableConstructor) {
            boolean _greaterEqualsThan;
            boolean _not_1;
            boolean _not;
            EObject _eContainer = method.eContainer();
            boolean bl = _not = !(_eContainer instanceof N4ClassDefinition);
            if (_not) {
                this.addIssue(IssueCodes.getMessageForCLF_CTOR_CALLABLE_ONLY_IN_CLASS(), (EObject)method, "CLF_CTOR_CALLABLE_ONLY_IN_CLASS");
                return false;
            }
            boolean _isExternalMode = this.jsVariantHelper.isExternalMode((EObject)method);
            boolean bl2 = _not_1 = !_isExternalMode;
            if (_not_1) {
                this.addIssue(IssueCodes.getMessageForCLF_CTOR_CALLABLE_ONLY_IN_N4JSD(), (EObject)method, "CLF_CTOR_CALLABLE_ONLY_IN_N4JSD");
                return false;
            }
            EObject _eContainer_1 = method.eContainer();
            Functions.Function1 _function = it -> it.isCallableConstructor();
            int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)((N4ClassifierDefinition)_eContainer_1).getOwnedMembersRaw(), (Functions.Function1)_function));
            boolean bl3 = _greaterEqualsThan = _size >= 2;
            if (_greaterEqualsThan) {
                this.addIssue(IssueCodes.getMessageForCLF_CTOR_CALLABLE_DUPLICATE(), (EObject)method, "CLF_CTOR_CALLABLE_DUPLICATE");
            }
        }
        return true;
    }

    private boolean holdsAbstractOrHasBody(TMember member) {
        boolean requireCheckForMissingBody = this.jsVariantHelper.requireCheckForMissingBody((EObject)member);
        boolean _switchResult = false;
        boolean _matched = false;
        if (member instanceof TMethod) {
            _matched = true;
            _switchResult = ((TMethod)member).isAbstract();
        }
        if (!_matched && member instanceof FieldAccessor) {
            _matched = true;
            _switchResult = ((FieldAccessor)member).isAbstract();
        }
        if (!_matched) {
            _switchResult = false;
        }
        boolean memberIsAbstract = _switchResult;
        if (requireCheckForMissingBody && !memberIsAbstract && this.getBody((N4MemberDeclaration)member.getAstElement()) == null) {
            boolean _isConstructor = member.isConstructor();
            if (_isConstructor) {
                this.addIssue(IssueCodes.getMessageForCLF_MISSING_CTOR_BODY(), member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_MISSING_CTOR_BODY", new String[0]);
            } else {
                String message = IssueCodes.getMessageForCLF_MISSING_BODY(this.keywordProvider.keyword(member), member.getName());
                this.addIssue(message, member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_MISSING_BODY", new String[0]);
            }
            return false;
        }
        return true;
    }

    private boolean holdsAbstractMethodMustNotBeStatic(TMember member) {
        if (member.isAbstract() && member.isStatic()) {
            this.addIssue(IssueCodes.getMessageForCLF_STATIC_ABSTRACT(this.keywordProvider.keyword(member), member.getName()), member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_STATIC_ABSTRACT", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsAbstractMethodMustHaveNoBody(TMember member) {
        if (member.isAbstract() && this.getBody((N4MemberDeclaration)member.getAstElement()) != null) {
            String message = IssueCodes.getMessageForCLF_ABSTRACT_BODY();
            this.addIssue(message, member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_ABSTRACT_BODY", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsAbstractMemberContainedInAbstractClassifier(TMember member) {
        TClassifier classifier;
        boolean _isAbstract = member.isAbstract();
        if (_isAbstract && (classifier = (TClassifier)EcoreUtil2.getContainerOfType((EObject)member, TClassifier.class)) != null && !classifier.isAbstract()) {
            String message = IssueCodes.getMessageForCLF_ABSTRACT_MISSING(this.keywordProvider.keyword(member), member.getName(), classifier.getName());
            this.addIssue(message, member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_ABSTRACT_MISSING", new String[0]);
            return false;
        }
        return true;
    }

    private void internalCheckPrivateOrProjectWithInternalAnnotation(N4MemberDeclaration n4Member, TMember tmember) {
        boolean _hasAnnotation = AnnotationDefinition.INTERNAL.hasAnnotation((AnnotableElement)n4Member);
        if (_hasAnnotation) {
            boolean hasProjectModifier;
            MemberAccessModifier memberAccessModifier = tmember.getMemberAccessModifier();
            boolean hasPrivateModifier = memberAccessModifier == MemberAccessModifier.PRIVATE;
            boolean bl = hasProjectModifier = memberAccessModifier == MemberAccessModifier.PROJECT;
            if (hasPrivateModifier || hasProjectModifier) {
                String message = IssueCodes.getMessageForCLF_INTERNAL_BAD_WITH_PRIVATE_OR_PROJECT();
                this.addIssue(message, tmember.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_INTERNAL_BAD_WITH_PRIVATE_OR_PROJECT", new String[0]);
            }
        }
    }

    private boolean holdsMinimalMemberAccessModifier(TMember member) {
        MemberAccessModifier memberAccessModifier;
        ContainerType _containingType = member.getContainingType();
        if (_containingType instanceof TInterface && (memberAccessModifier = member.getMemberAccessModifier()) == MemberAccessModifier.PRIVATE) {
            String message = IssueCodes.getMessageForCLF_MINIMAL_ACCESSIBILITY_IN_INTERFACES();
            this.addIssue(message, member.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_MINIMAL_ACCESSIBILITY_IN_INTERFACES", new String[0]);
            return false;
        }
        return true;
    }

    private void internalCheckGetterType(N4GetterDeclaration n4GetterDeclaration) {
        Type getterType;
        TypeRef _declaredTypeRef = n4GetterDeclaration.getDeclaredTypeRef();
        Type _declaredType = null;
        if (_declaredTypeRef != null) {
            _declaredType = _declaredTypeRef.getDeclaredType();
        }
        if ((getterType = _declaredType) != null && getterType instanceof VoidType) {
            String message = IssueCodes.getMessageForCLF_VOID_ACCESSOR();
            this.addIssue(message, (EObject)n4GetterDeclaration, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_VOID_ACCESSOR", new String[0]);
        }
    }

    @Check
    public void checkDuplicateFieldsIn(ThisTypeRefStructural thisTypeRefStructural) {
        Type tClass;
        N4ClassifierDefinition n4ClassifierDefinition = (N4ClassifierDefinition)EcoreUtil2.getContainerOfType((EObject)thisTypeRefStructural, N4ClassifierDefinition.class);
        if (n4ClassifierDefinition != null && (tClass = n4ClassifierDefinition.getDefinedType()) instanceof TClass) {
            this.internalCheckDuplicateFieldsIn((TClass)tClass, thisTypeRefStructural);
        }
    }

    private void internalCheckDuplicateFieldsIn(TClass tclass, ThisTypeRefStructural thisTypeRefStructural) {
        TypingStrategy _typingStrategy = thisTypeRefStructural.getTypingStrategy();
        boolean structFieldInitMode = Objects.equal((Object)_typingStrategy, (Object)TypingStrategy.STRUCTURAL_FIELD_INITIALIZER);
        List<TMember> members = LazyOverrideAwareMemberCollector.collectAllMembers(tclass);
        Functions.Function1 _function = it -> Tuples.pair((Object)it.getName(), (Object)it.isStatic());
        Map membersByNameAndStatic = IterableExtensions.groupBy(members, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> Tuples.pair((Object)it.getName(), (Object)it.isStatic());
        Map structuralMembersByNameAndStatic = IterableExtensions.groupBy((Iterable)thisTypeRefStructural.getStructuralMembers(), (Functions.Function1)_function_1);
        Consumer<org.eclipse.xtext.util.Pair> _function_2 = it -> {
            boolean _containsKey = membersByNameAndStatic.containsKey(it);
            if (_containsKey) {
                boolean _equals;
                TStructMember structuralFieldDuplicate = (TStructMember)IterableExtensions.head((Iterable)((Iterable)structuralMembersByNameAndStatic.get(it)));
                TMember existingClassifierMember = this.headExceptNonExistantGetters((Iterable)membersByNameAndStatic.get(it), structFieldInitMode);
                MemberAccessModifier _memberAccessModifier = null;
                if (existingClassifierMember != null) {
                    _memberAccessModifier = existingClassifierMember.getMemberAccessModifier();
                }
                if (_equals = Objects.equal((Object)_memberAccessModifier, (Object)MemberAccessModifier.PUBLIC)) {
                    String message = IssueCodes.getMessageForCLF_DUP_MEMBER(this.validatorMessageHelper.descriptionWithLine((TMember)structuralFieldDuplicate), this.validatorMessageHelper.descriptionWithLine(existingClassifierMember));
                    int index = thisTypeRefStructural.getStructuralMembers().indexOf((Object)structuralFieldDuplicate);
                    this.addIssue(message, (EObject)thisTypeRefStructural, (EStructuralFeature)TypeRefsPackage.Literals.STRUCTURAL_TYPE_REF__AST_STRUCTURAL_MEMBERS, index, "CLF_DUP_MEMBER", new String[0]);
                }
            }
        };
        structuralMembersByNameAndStatic.keySet().forEach(_function_2);
    }

    private TMember headExceptNonExistantGetters(Iterable<? extends TMember> members, boolean structFieldInitMode) {
        if (structFieldInitMode) {
            Functions.Function1 _function = it -> !(it instanceof TGetter);
            return (TMember)IterableExtensions.head((Iterable)IterableExtensions.filter(members, (Functions.Function1)_function));
        }
        return (TMember)IterableExtensions.head(members);
    }

    @Check
    public void checkFixmeUsedWithTestAnnotation(N4MethodDeclaration methodDecl) {
        Consumer<AnnotationDefinition> _function = annotation -> {
            if (annotation.hasAnnotation((AnnotableElement)methodDecl) && !AnnotationDefinition.TEST_METHOD.hasAnnotation((AnnotableElement)methodDecl)) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("@");
                _builder.append(annotation.name);
                Functions.Function1 _function_1 = it -> {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)annotationDefinition.name);
                };
                this.addIssue(IssueCodes.getMessageForANN_REQUIRES_TEST(_builder), (EObject)IterableExtensions.findFirst((Iterable)methodDecl.getAnnotations(), (Functions.Function1)_function_1), (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "ANN_REQUIRES_TEST", new String[0]);
            }
        };
        ANNOTATIONS_REQUIRE_TEST.forEach(_function);
    }
}

