/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public abstract class ComposedMemberDescriptionWithError
extends AbstractDescriptionWithError {
    protected final ComposedTypeRef composedTypeRef;
    protected final IScope[] subScopes;
    protected final boolean writeAccess;
    protected final int max;
    protected String message;
    protected String code;

    protected abstract boolean initMessageAndCode(List<String> var1, MapOfIndexes<String> var2, QualifiedName var3, boolean var4, IEObjectDescription[] var5, MapOfIndexes<String> var6);

    public ComposedMemberDescriptionWithError(IEObjectDescription delegate, ComposedTypeRef composedTypeRef, IScope[] subScopes, boolean writeAccess) {
        super(delegate);
        this.composedTypeRef = composedTypeRef;
        this.subScopes = subScopes;
        this.max = subScopes.length;
        this.writeAccess = writeAccess;
    }

    public String getMessage() {
        this.initialize();
        return this.message;
    }

    public String getIssueCode() {
        this.initialize();
        return this.code;
    }

    private boolean initialize() {
        if (this.message == null) {
            EList typeRefs = this.composedTypeRef.getTypeRefs();
            IEObjectDescription[] descriptions = new IEObjectDescription[this.subScopes.length];
            MapOfIndexes<String> indexesPerMemberType = new MapOfIndexes<String>();
            MapOfIndexes<String> indexesPerCode = new MapOfIndexes<String>();
            ArrayList<String> missingFrom = new ArrayList<String>();
            QualifiedName name = this.getName();
            boolean readOnlyField = false;
            int i = 0;
            while (i < this.max) {
                IEObjectDescription description = this.subScopes[i].getSingleElement(name);
                if (description != null) {
                    descriptions[i] = description;
                    EObject eobj = description.getEObjectOrProxy();
                    boolean structFieldInitMode = ((TypeRef)typeRefs.get(i)).getTypingStrategy() == TypingStrategy.STRUCTURAL_FIELD_INITIALIZER;
                    String type = ComposedMemberDescriptionWithError.getMemberTypeName(eobj, structFieldInitMode);
                    indexesPerMemberType.add(type, i);
                    if (IEObjectDescriptionWithError.isErrorDescription((IEObjectDescription)description)) {
                        String subCode = IEObjectDescriptionWithError.getDescriptionWithError((IEObjectDescription)description).getIssueCode();
                        indexesPerCode.add(subCode, i);
                    }
                    if ("field".equals(type)) {
                        readOnlyField |= !((TField)eobj).isWriteable();
                    }
                } else {
                    missingFrom.add(this.getNameForSubScope(i));
                }
                ++i;
            }
            return this.initMessageAndCode(missingFrom, indexesPerMemberType, name, readOnlyField, descriptions, indexesPerCode);
        }
        return false;
    }

    protected boolean initSubMessages(IEObjectDescription[] descriptions, MapOfIndexes<String> indexesPerCode) {
        if (indexesPerCode.size() == 1 && indexesPerCode.numberOf((String)indexesPerCode.firstKey()) == this.max) {
            this.code = (String)indexesPerCode.firstKey();
            int index = indexesPerCode.firstIndex(this.code);
            this.message = ((IEObjectDescriptionWithError)descriptions[index]).getMessage();
            String scopeName = this.getNameForSubScope(index);
            this.message.replace(scopeName, "all types");
            return true;
        }
        if (indexesPerCode.size() > 0) {
            StringBuilder strb = new StringBuilder();
            for (String subCode : indexesPerCode.keySet()) {
                String completeSubMessage;
                int index = indexesPerCode.firstIndex(subCode);
                IEObjectDescriptionWithError descrWithError = (IEObjectDescriptionWithError)descriptions[index];
                String submessage = descrWithError.getMessage();
                String scopeName = this.getNameForSubScope(index);
                String allScopeNames = indexesPerCode.getScopeNamesForKey(subCode);
                if (submessage.contains(scopeName)) {
                    completeSubMessage = submessage.replace(scopeName, allScopeNames);
                } else {
                    if (submessage.endsWith(".")) {
                        submessage = submessage.substring(0, submessage.length() - 1);
                    }
                    completeSubMessage = IssueCodes.getMessageForCOMP_SUBMESSAGES(allScopeNames, submessage);
                }
                if (strb.length() > 0) {
                    strb.append(" ");
                }
                strb.append(completeSubMessage);
            }
            this.message = strb.toString();
            this.code = "COMP_SUBMESSAGES";
            return true;
        }
        return false;
    }

    private String getNameForSubScope(int idx) {
        TypeRef typeRef;
        if (idx < this.composedTypeRef.getTypeRefs().size() && (typeRef = (TypeRef)this.composedTypeRef.getTypeRefs().get(idx)) != null) {
            return typeRef.getTypeRefAsString();
        }
        return null;
    }

    class MapOfIndexes<T_Key>
    extends TreeMap<T_Key, List<Integer>> {
        MapOfIndexes() {
        }

        void add(T_Key key, int index) {
            if (key != null) {
                ArrayList<Integer> indexes = (ArrayList<Integer>)this.get(key);
                if (indexes == null) {
                    indexes = new ArrayList<Integer>(ComposedMemberDescriptionWithError.this.max);
                    this.put(key, indexes);
                }
                indexes.add(index);
            }
        }

        int numberOf(T_Key key) {
            List indexes = (List)this.get(key);
            if (indexes == null) {
                return 0;
            }
            return indexes.size();
        }

        String getScopeNamesForKey(T_Key key) {
            List indexes = (List)this.get(key);
            if (indexes == null) {
                return null;
            }
            StringBuilder strb = new StringBuilder();
            Iterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (strb.length() != 0) {
                    strb.append(", ");
                }
                strb.append(ComposedMemberDescriptionWithError.this.getNameForSubScope(i));
            }
            return strb.toString();
        }

        int firstIndex(T_Key key) {
            List indexes = (List)this.get(key);
            if (indexes == null) {
                return -1;
            }
            return (Integer)indexes.get(0);
        }
    }
}

