/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.eclipse.n4js.utils.Log;
import org.eclipse.n4js.validation.AbstractMessageAdjustingN4JSValidator;
import org.eclipse.n4js.validation.validators.IDEBUGValidator;
import org.eclipse.n4js.validation.validators.N4IDLMigrationValidator;
import org.eclipse.n4js.validation.validators.N4IDLValidator;
import org.eclipse.n4js.validation.validators.N4JSAccessModifierValidator;
import org.eclipse.n4js.validation.validators.N4JSAnnotationValidator;
import org.eclipse.n4js.validation.validators.N4JSClassValidator;
import org.eclipse.n4js.validation.validators.N4JSClassifierValidator;
import org.eclipse.n4js.validation.validators.N4JSDeclaredNameValidator;
import org.eclipse.n4js.validation.validators.N4JSDependencyInjectionValidator;
import org.eclipse.n4js.validation.validators.N4JSDestructureValidator;
import org.eclipse.n4js.validation.validators.N4JSEnumValidator;
import org.eclipse.n4js.validation.validators.N4JSExpressionValidator;
import org.eclipse.n4js.validation.validators.N4JSExternalValidator;
import org.eclipse.n4js.validation.validators.N4JSFlowgraphValidator;
import org.eclipse.n4js.validation.validators.N4JSFunctionValidator;
import org.eclipse.n4js.validation.validators.N4JSImportValidator;
import org.eclipse.n4js.validation.validators.N4JSInjectorCallsitesValidator;
import org.eclipse.n4js.validation.validators.N4JSInterfaceValidator;
import org.eclipse.n4js.validation.validators.N4JSLambdaValidator;
import org.eclipse.n4js.validation.validators.N4JSMemberRedefinitionValidator;
import org.eclipse.n4js.validation.validators.N4JSMemberValidator;
import org.eclipse.n4js.validation.validators.N4JSModuleValidator;
import org.eclipse.n4js.validation.validators.N4JSNameValidator;
import org.eclipse.n4js.validation.validators.N4JSStatementValidator;
import org.eclipse.n4js.validation.validators.N4JSSuperValidator;
import org.eclipse.n4js.validation.validators.N4JSSyntaxValidator;
import org.eclipse.n4js.validation.validators.N4JSTypeValidator;
import org.eclipse.n4js.validation.validators.N4JSVariableValidator;
import org.eclipse.n4js.validation.validators.N4JSXValidator;
import org.eclipse.n4js.validation.validators.ThirdPartyValidator;
import org.eclipse.n4js.validation.validators.UnsupportedFeatureValidator;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.xbase.lib.Exceptions;

@ComposedChecks(validators={IDEBUGValidator.class, N4JSAccessModifierValidator.class, N4JSAnnotationValidator.class, N4JSClassifierValidator.class, N4JSClassValidator.class, N4JSDeclaredNameValidator.class, N4JSDependencyInjectionValidator.class, N4JSDestructureValidator.class, N4JSEnumValidator.class, N4JSExpressionValidator.class, N4JSExternalValidator.class, N4JSFlowgraphValidator.class, N4JSFunctionValidator.class, N4JSImportValidator.class, N4JSInjectorCallsitesValidator.class, N4JSInterfaceValidator.class, N4JSLambdaValidator.class, N4JSMemberRedefinitionValidator.class, N4JSMemberValidator.class, N4JSModuleValidator.class, N4JSNameValidator.class, N4JSStatementValidator.class, N4JSSuperValidator.class, N4JSSyntaxValidator.class, N4JSTypeValidator.class, N4JSVariableValidator.class, N4JSXValidator.class, ThirdPartyValidator.class, UnsupportedFeatureValidator.class, N4IDLValidator.class, N4IDLMigrationValidator.class})
@Log
public class N4JSValidator
extends AbstractMessageAdjustingN4JSValidator {
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private static final Logger logger = Logger.getLogger(N4JSValidator.class);

    public AbstractMessageAdjustingN4JSValidator.MethodWrapperCancelable createMethodWrapper(AbstractDeclarativeValidator instanceToUse, Method method) {
        return new N4JSMethodWrapperCancelable(instanceToUse, method, this.operationCanceledManager);
    }

    public static class N4JSMethodWrapperCancelable
    extends AbstractMessageAdjustingN4JSValidator.MethodWrapperCancelable {
        private OperationCanceledManager operationCanceledManager;

        public N4JSMethodWrapperCancelable(AbstractDeclarativeValidator instance, Method m, OperationCanceledManager operationCanceledManager) {
            super(instance, m);
            this.operationCanceledManager = operationCanceledManager;
        }

        public void handleInvocationTargetException(Throwable targetException, AbstractDeclarativeValidator.State state) {
            super.handleInvocationTargetException(targetException, state);
            if (targetException instanceof NullPointerException) {
                Exceptions.sneakyThrow((Throwable)targetException);
            }
        }

        public void invoke(AbstractDeclarativeValidator.State state) {
            String valMethodName = this.getMethod().getName();
            URI URI2 = state.currentObject.eResource().getURI();
            this.operationCanceledManager.checkCanceled(this.getCancelIndicator(state));
            DataCollector dcCheckMethod = N4JSDataCollectors.createDataCollectorForCheckMethod((String)valMethodName);
            String _string = URI2.toString();
            String _plus = String.valueOf(valMethodName) + "_" + _string;
            try (Measurement mesVM = dcCheckMethod.getMeasurement(_plus);){
                try {
                    super.invoke(state);
                }
                catch (Throwable _t) {
                    if (!(_t instanceof Exception)) {
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    Exception e = (Exception)_t;
                    this.operationCanceledManager.propagateIfCancelException((Throwable)e);
                    logger.error((Object)"Error executing EValidator", (Throwable)e);
                    String _string_1 = state.currentObject.toString();
                    String _message = e.getMessage();
                    BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, _string_1, 0, _message, new Object[]{e});
                    state.chain.add((Diagnostic)_basicDiagnostic);
                    mesVM.close();
                }
            }
        }
    }
}

