/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.xpect.text.ITextBlock;
import org.eclipse.xpect.text.Text;
import org.eclipse.xtext.util.Strings;

public class TextBlock
implements ITextBlock {
    private final String[] lines;

    private static void collectLines(Object obj, List<String> lines) {
        if (obj == null) {
            lines.add("(null)");
        } else if (obj instanceof Iterable) {
            for (Object o : (Iterable)obj) {
                TextBlock.collectLines(o, lines);
            }
        } else {
            lines.addAll(new Text(obj.toString()).splitIntoLines());
        }
    }

    public static ITextBlock get(Object obj) {
        if (obj instanceof ITextBlock) {
            return (ITextBlock)obj;
        }
        ArrayList lines = Lists.newArrayList();
        TextBlock.collectLines(obj, lines);
        if (lines.isEmpty()) {
            return ITextBlock.EMPTY;
        }
        for (String line : lines) {
            if (Strings.isEmpty((String)line)) continue;
            return new TextBlock(lines.toArray(new String[lines.size()]));
        }
        return ITextBlock.EMPTY;
    }

    private TextBlock(String[] lines) {
        this.lines = lines;
    }

    @Override
    public List<String> getLines() {
        return Arrays.asList(this.lines);
    }

    public String toString() {
        return Joiner.on((char)'\n').join((Object[])this.lines);
    }
}

