/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.util.Arrays;

public class N4JSResourceDescriptionDelta
extends DefaultResourceDescriptionDelta {
    private static final Set<String> IGNORED_USERDATA_KEYS = Sets.newHashSet((Object[])new String[]{"astMD5"});

    public N4JSResourceDescriptionDelta(IResourceDescription oldDescription, IResourceDescription newDescription) {
        super(oldDescription, newDescription);
    }

    protected boolean isIgnoredUserDataKey(String key) {
        return IGNORED_USERDATA_KEYS.contains(key);
    }

    protected boolean equals(IEObjectDescription oldObj, IEObjectDescription newObj) {
        Object[] newKeys;
        if (oldObj == newObj) {
            return true;
        }
        if (oldObj.getEClass() != newObj.getEClass()) {
            return false;
        }
        if (oldObj.getName() != null && !oldObj.getName().equals((Object)newObj.getName())) {
            return false;
        }
        if (!oldObj.getEObjectURI().equals(newObj.getEObjectURI())) {
            return false;
        }
        String[] oldKeys = oldObj.getUserDataKeys();
        if (oldKeys.length != (newKeys = newObj.getUserDataKeys()).length) {
            return false;
        }
        String[] stringArray = oldKeys;
        int n = oldKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (!this.isIgnoredUserDataKey(key)) {
                if (!Arrays.contains((Object[])newKeys, (Object)key)) {
                    return false;
                }
                String oldValue = oldObj.getUserData(key);
                String newValue = newObj.getUserData(key);
                if (oldValue == null ? newValue != null : !oldValue.equals(newValue)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }
}

