/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class AssertionVMArg {
    private static final String LONG_VM_ARG_TEXT = "-enableassertions";
    private static final String SHORT_VM_ARG_TEXT = "-ea";
    public static final int ASSERT_ARG_NOT_FOUND = -1;

    public static void setArgDefault(ILaunchConfigurationWorkingCopy config) {
        String argText = AssertionVMArg.getEnableAssertionsPreference() ? SHORT_VM_ARG_TEXT : "";
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, argText);
    }

    public static String enableAssertInArgString(String currentArgs) {
        String[] argArray = DebugPlugin.parseArguments((String)currentArgs);
        boolean assertAlreadyEnabled = AssertionVMArg.findAssertEnabledArg(argArray) != -1;
        String result = currentArgs;
        if (!assertAlreadyEnabled && AssertionVMArg.getEnableAssertionsPreference()) {
            result = AssertionVMArg.setAssertInArgString(currentArgs);
        }
        return result;
    }

    public static int findAssertEnabledArg(String[] argArray) {
        int assertArgIndex = -1;
        int i = 0;
        while (i < argArray.length) {
            String arg = argArray[i].toLowerCase();
            if (arg.startsWith(SHORT_VM_ARG_TEXT) || arg.startsWith(LONG_VM_ARG_TEXT)) {
                assertArgIndex = i;
                break;
            }
            ++i;
        }
        return assertArgIndex;
    }

    public static String setAssertInArgString(String currentArgs) {
        return currentArgs.length() == 0 ? SHORT_VM_ARG_TEXT : String.valueOf(currentArgs) + " " + SHORT_VM_ARG_TEXT;
    }

    public static boolean getEnableAssertionsPreference() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.jdt.junit.core", "org.eclipse.jdt.junit.enable_assertions", true, null);
    }

    public static void setEnableAssertionsPreference(boolean preference) {
        InstanceScope.INSTANCE.getNode("org.eclipse.jdt.junit.core").putBoolean("org.eclipse.jdt.junit.enable_assertions", preference);
    }
}

