/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.internal;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import org.eclipse.n4js.tester.server.HttpServerManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class TesterActivator
implements BundleActivator {
    private static BundleContext context;
    private static TesterActivator instance;
    private Injector injector;
    private int effectiveServerPort = -1;
    private Integer configuredServerPort;
    private HttpServerManager serverManager;

    static BundleContext getContext() {
        return context;
    }

    public static TesterActivator getInstance() {
        return instance;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        instance = this;
    }

    public void startupWithInjector(Injector uiInjector) {
        this.injector = uiInjector;
        this.serverManager = (HttpServerManager)this.injector.getInstance(HttpServerManager.class);
        this.configuredServerPort = (Integer)this.injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"httpServerPortKey")));
        Map<String, Object> portMap = Collections.singletonMap("http.port", this.configuredServerPort);
        this.effectiveServerPort = this.serverManager.startServer(portMap);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        instance = null;
        context = null;
        this.effectiveServerPort = -1;
        if (this.serverManager != null) {
            this.serverManager.stopServer(-1);
        }
    }

    public int getServerPort() {
        return this.effectiveServerPort;
    }

    public static Injector getInjector() {
        return TesterActivator.getInstance().injector;
    }
}

