/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.BranchRebaseModeCombo;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BranchConfigurationDialog
extends TitleAreaDialog {
    private final String myBranchName;
    private final Repository myRepository;
    private final StoredConfig myConfig;
    private final String myTitle;
    private Combo remoteText;
    private Combo branchText;
    private BranchRebaseModeCombo rebase;

    public BranchConfigurationDialog(Shell shell, String branchName, Repository repository) {
        super(shell);
        this.myBranchName = branchName;
        this.myRepository = repository;
        this.myConfig = this.myRepository.getConfig();
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.myTitle = UIText.BranchConfigurationDialog_BranchConfigurationTitle;
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Label remoteLabel = new Label(main, 0);
        remoteLabel.setText(UIText.BranchConfigurationDialog_RemoteLabel);
        this.remoteText = new Combo(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.remoteText);
        Label branchLabel = new Label(main, 0);
        branchLabel.setText(UIText.BranchConfigurationDialog_UpstreamBranchLabel);
        this.branchText = new Combo(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.branchText);
        this.remoteText.add(".");
        for (String remote : this.myConfig.getSubsections("remote")) {
            this.remoteText.add(remote);
        }
        this.remoteText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchConfigurationDialog.this.updateBranchItems();
            }
        });
        this.rebase = new BranchRebaseModeCombo(main);
        BranchConfig.BranchRebaseMode rebaseMode = PullCommand.getRebaseMode((String)this.myBranchName, (Config)this.myConfig);
        this.rebase.setRebaseMode(rebaseMode);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)this.rebase.getViewer().getCombo());
        String branch = this.myConfig.getString("branch", this.myBranchName, "merge");
        if (branch == null) {
            branch = "";
        }
        this.branchText.setText(branch);
        String remote = this.myConfig.getString("branch", this.myBranchName, "remote");
        if (remote == null) {
            remote = "";
        }
        this.remoteText.setText(remote);
        this.updateBranchItems();
        BranchConfigurationDialog.applyDialogFont((Control)main);
        return main;
    }

    private void updateBranchItems() {
        String branchTextBefore = this.branchText.getText();
        this.branchText.removeAll();
        this.addBranchItems();
        this.branchText.setText(branchTextBefore);
    }

    private void addBranchItems() {
        String remote = this.remoteText.getText();
        try {
            if (remote.equals(".") || remote.length() == 0) {
                this.addBranchItemsForLocal();
            } else {
                this.addBranchItemsForRemote(remote);
            }
        }
        catch (IOException | URISyntaxException e) {
            Activator.logError(UIText.BranchConfigurationDialog_ExceptionGettingRefs, e);
        }
    }

    private void addBranchItemsForLocal() throws IOException {
        ArrayList localRefs = new ArrayList(this.myRepository.getRefDatabase().getRefsByPrefix("refs/heads/"));
        Collections.sort(localRefs, CommonUtils.REF_ASCENDING_COMPARATOR);
        for (Ref ref : localRefs) {
            this.branchText.add(ref.getName());
        }
    }

    private void addBranchItemsForRemote(String remote) throws IOException, URISyntaxException {
        RemoteConfig remoteConfig = new RemoteConfig((Config)this.myConfig, remote);
        List fetchSpecs = remoteConfig.getFetchRefSpecs();
        if (fetchSpecs.isEmpty()) {
            return;
        }
        ArrayList allRefs = new ArrayList(this.myRepository.getRefDatabase().getRefsByPrefix("refs/"));
        Collections.sort(allRefs, CommonUtils.REF_ASCENDING_COMPARATOR);
        for (Ref ref : allRefs) {
            for (RefSpec fetchSpec : fetchSpecs) {
                if (!fetchSpec.matchDestination(ref)) continue;
                RefSpec source = fetchSpec.expandFromDestination(ref);
                String refNameOnRemote = source.getSource();
                this.branchText.add(refNameOnRemote);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.BranchConfigurationDialog_BranchConfigurationTitle);
    }

    public void create() {
        super.create();
        this.setTitle(this.myTitle);
        this.setMessage(NLS.bind((String)UIText.BranchConfigurationDialog_EditBranchConfigMessage, (Object)this.myBranchName));
    }

    protected void okPressed() {
        try {
            String merge = this.branchText.getText();
            if (merge.length() > 0) {
                this.myConfig.setString("branch", this.myBranchName, "merge", merge);
            } else {
                this.myConfig.unset("branch", this.myBranchName, "merge");
            }
            String remote = this.remoteText.getText();
            if (remote.length() > 0) {
                this.myConfig.setString("branch", this.myBranchName, "remote", remote);
            } else {
                this.myConfig.unset("branch", this.myBranchName, "remote");
            }
            BranchConfig.BranchRebaseMode rebaseMode = this.rebase.getRebaseMode();
            if (rebaseMode == null) {
                this.myConfig.unset("branch", this.myBranchName, "rebase");
            } else {
                this.myConfig.setEnum("branch", this.myBranchName, "rebase", (Enum)rebaseMode);
            }
            try {
                this.myConfig.save();
                super.okPressed();
            }
            catch (IOException e) {
                Activator.handleError(UIText.BranchConfigurationDialog_SaveBranchConfigFailed, e, true);
            }
        }
        catch (RuntimeException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, UIText.BranchConfigurationDialog_ButtonOK, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

