/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.ui.search;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.validation.TypesKeywordProvider;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class ReferenceFinderLabelProvider {
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private IResourceServiceProvider resourceServiceProvider;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private TypesKeywordProvider keywordProvider;

    public String getText(EObject source) {
        ReferenceFinderLabelProvider otherLabelProvider;
        IResourceServiceProvider otherServiceProvider;
        URI uri = source.eResource().getURI();
        if (!this.resourceServiceProvider.canHandle(uri) && (otherServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(uri)) != null && (otherLabelProvider = (ReferenceFinderLabelProvider)otherServiceProvider.get(ReferenceFinderLabelProvider.class)) != null) {
            return otherLabelProvider.doGetText(source);
        }
        return this.doGetText(source);
    }

    protected String doGetText(EObject source) {
        String keyword = this.getKeywordLabel(source);
        QualifiedName containerName = this.qualifiedNameProvider.getFullyQualifiedName(source);
        while (containerName == null) {
            if ((source = source.eContainer()) == null) break;
            containerName = this.qualifiedNameProvider.getFullyQualifiedName(source);
        }
        if (keyword != null && keyword.length() > 0) {
            return String.valueOf(keyword) + ' ' + containerName;
        }
        return String.valueOf(containerName);
    }

    protected String getKeywordLabel(EObject source) {
        while (source instanceof TypeRef) {
            source = source.eContainer();
        }
        if (source != null) {
            return this.keywordProvider.keyword((Object)source);
        }
        return null;
    }
}

