/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesbuilder.N4JSFormalParameterTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

abstract class AbstractFunctionDefinitionTypesBuilder {
    @Inject
    @Extension
    private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;
    @Inject
    @Extension
    private N4JSFormalParameterTypesBuilder _n4JSFormalParameterTypesBuilder;

    AbstractFunctionDefinitionTypesBuilder() {
    }

    protected void relinkFormalParameters(TFunction functionType, FunctionDefinition functionDef, boolean preLinkingPhase) {
        Functions.Function2 _function = (idx, fpar) -> {
            boolean _relinkFormalParameter = this._n4JSFormalParameterTypesBuilder.relinkFormalParameter((FormalParameter)fpar, functionType, preLinkingPhase, (int)idx);
            if (_relinkFormalParameter) {
                return idx + 1;
            }
            return idx;
        };
        IterableExtensions.fold((Iterable)functionDef.getFpars(), (Object)0, (Functions.Function2)_function);
    }

    protected void addFormalParameters(TFunction functionType, FunctionDefinition functionDef, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        Functions.Function1 _function = it -> this._n4JSFormalParameterTypesBuilder.createFormalParameter((FormalParameter)it, builtInTypeScope, preLinkingPhase);
        Iterables.addAll((Collection)functionType.getFpars(), (Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)functionDef.getFpars(), (Functions.Function1)_function)));
    }

    protected void addTypeVariables(TFunction functionType, GenericDeclaration genericDecl, boolean preLinkingPhase) {
        this._n4JSTypesBuilderHelper.addCopyOfReferences(functionType.getTypeVars(), genericDecl.getTypeVars());
    }

    protected void setReturnType(TGetter getterType, N4GetterDeclaration getterDef, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        if (!preLinkingPhase) {
            boolean _tripleEquals;
            TypeRef _xifexpression = null;
            TypeRef _declaredTypeRef = getterDef.getDeclaredTypeRef();
            boolean bl = _tripleEquals = _declaredTypeRef == null;
            if (_tripleEquals) {
                ParameterizedTypeRef _xifexpression_1 = null;
                if (!preLinkingPhase) {
                    ParameterizedTypeRef _xifexpression_2 = null;
                    boolean _isAbstract = getterType.isAbstract();
                    _xifexpression_2 = _isAbstract ? builtInTypeScope.getAnyTypeRef() : this.inferReturnTypeFromReturnStatements(getterDef, builtInTypeScope);
                    _xifexpression_1 = _xifexpression_2;
                }
                _xifexpression = _xifexpression_1;
            } else {
                _xifexpression = getterDef.getDeclaredTypeRef();
            }
            TypeRef inferredReturnTypeRef = _xifexpression;
            getterType.setDeclaredTypeRef((TypeRef)TypeUtils.copyWithProxies((EObject)inferredReturnTypeRef));
        }
    }

    protected void setReturnType(TFunction functionType, FunctionDefinition functionDef, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        if (!preLinkingPhase) {
            boolean _tripleEquals;
            TypeRef _xifexpression = null;
            TypeRef _returnTypeRef = functionDef.getReturnTypeRef();
            boolean bl = _tripleEquals = _returnTypeRef == null;
            if (_tripleEquals) {
                ParameterizedTypeRef _xifexpression_1 = null;
                if (!preLinkingPhase) {
                    _xifexpression_1 = this.inferReturnTypeFromReturnStatements(functionDef, builtInTypeScope);
                }
                _xifexpression = _xifexpression_1;
            } else {
                _xifexpression = functionDef.getReturnTypeRef();
            }
            TypeRef inferredReturnTypeRef = _xifexpression;
            functionType.setReturnTypeRef((TypeRef)TypeUtils.copyWithProxies((EObject)inferredReturnTypeRef));
        }
    }

    protected ParameterizedTypeRef inferReturnTypeFromReturnStatements(FunctionDefinition definition, BuiltInTypeScope builtInTypeScope) {
        boolean hasNonVoidReturn;
        boolean bl = hasNonVoidReturn = definition.getBody() != null && definition.getBody().hasNonVoidReturn();
        if (hasNonVoidReturn) {
            return builtInTypeScope.getAnyTypeRef();
        }
        boolean _isSingleExprArrowFunction = this.isSingleExprArrowFunction(definition);
        if (_isSingleExprArrowFunction) {
            return builtInTypeScope.getAnyTypeRef();
        }
        return builtInTypeScope.getVoidTypeRef();
    }

    private boolean isSingleExprArrowFunction(FunctionDefinition definition) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (definition instanceof ArrowFunction) {
            _matched = true;
            _switchResult = ((ArrowFunction)definition).isSingleExprImplicitReturn();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    protected ParameterizedTypeRef inferReturnTypeFromReturnStatements(N4GetterDeclaration definition, BuiltInTypeScope builtInTypeScope) {
        ParameterizedTypeRef _xblockexpression = null;
        boolean hasNonVoidReturn = definition.getBody() != null && definition.getBody().hasNonVoidReturn();
        ParameterizedTypeRef _xifexpression = null;
        _xifexpression = hasNonVoidReturn ? builtInTypeScope.getAnyTypeRef() : builtInTypeScope.getVoidTypeRef();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

