/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.n4js.ui.dialog.CustomElementSelectionDialog;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardValidatorUtils;
import org.eclipse.n4js.utils.OSInfo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ModuleSpecifierSelectionDialog
extends CustomElementSelectionDialog {
    private static Logger LOGGER = Logger.getLogger(ModuleSpecifierSelectionDialog.class);
    private static final String MODULE_ELEMENT_NAME = "Module:";
    private static final String CREATE_FOLDER_LABEL = "Create Folder";
    private static final String CREATE_A_NEW_FOLDER_MESSAGE = "Enter the name of the new folder";
    private static final String CREATE_A_NEW_FOLDER_TITLE = "Create a new folder";
    private static final String FAILED_TO_CREATE_FOLDER_TITLE = "Failed to create the folders";
    private static final String FAILED_TO_CREATE_FOLDER_MESSAGE = "The folder %s couldn't be created: %s";
    private static final String NON_EXISTING_MODULE_LOCATION_TITLE = "Non-existing module location";
    private static final String NON_EXISTING_MODULE_LOCATION_MESSAGE = "The module specifier you entered does not exist yet, do you want to create it in the file system?";
    private static final String SPECIFIER_OVERLAPS_WITH_FILE_TITLE = "Invalid module specifier";
    private static final String SPECIFIER_OVERLAPS_WITH_FILE_MESSAGE = "Your module specifier %s overlaps with the path of the file %s.";
    private final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private final IContainer sourceFolder;
    private final IContainer treeRoot;
    private final ModuleSpecifierValidator inputValidator = new ModuleSpecifierValidator();
    private String defaultFileExtension = "n4js";
    private String initialModuleName = "";

    public ModuleSpecifierSelectionDialog(Shell parent, IPath sourceFolder) {
        super(parent, MODULE_ELEMENT_NAME, CREATE_FOLDER_LABEL);
        this.setTitle("Select a module");
        this.setInputValidator(this.inputValidator);
        IPath parentPath = sourceFolder.removeLastSegments(1);
        IContainer sourceFolderParent = this.containerForPath(parentPath);
        IFolder workspaceSourceFolder = this.workspaceRoot.getFolder(sourceFolder);
        this.treeRoot = sourceFolderParent;
        this.sourceFolder = workspaceSourceFolder;
        this.addFilter(new ModuleFolderFilter(this.sourceFolder.getFullPath()));
        this.setAutoExpandLevel(2);
        this.setStatusLineAboveButtons(true);
    }

    @Override
    public void setInitialSelection(Object element) {
        super.setInitialSelection(element);
    }

    public int open() {
        Object initialSelection;
        if (this.getInitialElementSelections().size() > 0 && (initialSelection = this.getInitialElementSelections().get(0)) instanceof String) {
            this.setInitialSelection(this.processInitialSelection((String)initialSelection));
        }
        return super.open();
    }

    public void setDefaultFileExtension(String defaultFileExtension) {
        this.defaultFileExtension = defaultFileExtension;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control dialog = super.createDialogArea(parent);
        this.elementNameInput.setSuffix("." + this.defaultFileExtension);
        this.setInput(this.treeRoot);
        this.treeViewer.addSelectionChangedListener(selectionChange -> {
            this.updateFileExtension();
            this.validateElementInput();
            Object selection = this.treeViewer.getStructuredSelection().getFirstElement();
            if (selection instanceof IFile) {
                String extensionFreeFileName = ((IFile)selection).getFullPath().removeFileExtension().lastSegment();
                this.elementNameInput.setText(extensionFreeFileName);
            }
        });
        this.elementNameInput.addPropertyChangeListener(change -> this.updateFileExtension());
        this.treeViewer.setSelection(this.treeViewer.getSelection());
        if (!this.initialModuleName.isEmpty()) {
            this.elementNameInput.setText(this.initialModuleName);
        }
        this.validateElementInput();
        this.elementNameInput.setFocus();
        return dialog;
    }

    @Override
    protected void computeResult() {
        Object selection = this.treeViewer.getStructuredSelection().getFirstElement();
        if (selection == null) {
            return;
        }
        String moduleName = this.elementNameInput.getText();
        String moduleFileExtension = this.elementNameInput.getSuffix();
        if (selection instanceof IFile && ((IFile)selection).getFullPath().removeFileExtension().lastSegment().equals(moduleName)) {
            IPath fileSpec = this.sourceFolderRelativePath((IResource)selection);
            this.setResult(Arrays.asList(fileSpec.toString()));
            return;
        }
        if (selection instanceof IResource) {
            if (selection instanceof IFile) {
                selection = ((IFile)selection).getParent();
            }
            IFile moduleFile = ((IContainer)selection).getFile((IPath)new Path(String.valueOf(moduleName) + moduleFileExtension));
            this.setResult(Arrays.asList(moduleFile.getFullPath().makeRelativeTo(this.sourceFolder.getFullPath()).toString()));
            return;
        }
        this.updateError("Invalid selection type.");
    }

    @Override
    protected void createPressed() {
        InputDialog dialog = new InputDialog(this.getShell(), CREATE_A_NEW_FOLDER_TITLE, CREATE_A_NEW_FOLDER_MESSAGE, "", (IInputValidator)new ModuleFolderValidator());
        dialog.open();
        Object selection = this.treeViewer.getStructuredSelection().getFirstElement();
        IContainer parent = selection instanceof IFile ? ((IFile)selection).getParent() : (selection instanceof IContainer ? (IContainer)selection : this.sourceFolder);
        String dialogValue = dialog.getValue();
        if (OSInfo.isWindows()) {
            dialogValue = ModuleSpecifierSelectionDialog.convertToUnixPath(dialogValue);
        }
        if (dialog.getReturnCode() == 0) {
            Path folderPath = new Path(dialogValue);
            IContainer createdFolder = null;
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.open();
            IProgressMonitor progressMonitor = progressMonitorDialog.getProgressMonitor();
            createdFolder = this.createFolderPath((IPath)folderPath, parent, null);
            progressMonitor.done();
            progressMonitorDialog.close();
            if (createdFolder != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)createdFolder));
            }
        }
    }

    private IContainer containerForPath(IPath path) {
        if (path.segmentCount() == 1) {
            return this.workspaceRoot.getProject(path.segment(0));
        }
        return this.workspaceRoot.getFolder(path);
    }

    private Object processInitialSelection(String initialModuleSpecifier) {
        boolean create;
        IPath sourceFolderPath = this.sourceFolder.getFullPath();
        Path initialModulePath = new Path(initialModuleSpecifier);
        if (initialModuleSpecifier.isEmpty()) {
            return this.sourceFolder;
        }
        if (!WorkspaceWizardValidatorUtils.isValidFolderPath((IPath)initialModulePath)) {
            return this.sourceFolder;
        }
        IPath fullPath = sourceFolderPath.append((IPath)new Path(initialModuleSpecifier));
        if (!fullPath.hasTrailingSeparator()) {
            IFile n4jsModuleFile = this.workspaceRoot.getFile(fullPath.addFileExtension("n4js"));
            IFile n4jsdModuleFile = this.workspaceRoot.getFile(fullPath.addFileExtension("n4jsd"));
            if (n4jsModuleFile.exists()) {
                return n4jsModuleFile;
            }
            if (n4jsdModuleFile.exists()) {
                return n4jsdModuleFile;
            }
        }
        if (ModuleSpecifierSelectionDialog.isModuleFileSpecifier((IPath)initialModulePath)) {
            this.initialModuleName = initialModulePath.lastSegment();
            initialModulePath = initialModulePath.removeLastSegments(1);
        }
        IContainer selection = this.sourceFolder;
        IPath accumulatedPath = sourceFolderPath;
        ArrayList<IPath> nonExistingSegmentPaths = new ArrayList<IPath>();
        Iterator<String> segmentIterator = Arrays.asList(initialModulePath.segments()).iterator();
        while (segmentIterator.hasNext()) {
            IResource nextSegmentResource = this.workspaceRoot.findMember(accumulatedPath = accumulatedPath.append(segmentIterator.next()));
            if (nextSegmentResource != null && !(nextSegmentResource instanceof IContainer) && segmentIterator.hasNext()) {
                MessageDialog.open((int)1, (Shell)this.getShell(), (String)SPECIFIER_OVERLAPS_WITH_FILE_TITLE, (String)String.format(SPECIFIER_OVERLAPS_WITH_FILE_MESSAGE, initialModuleSpecifier, accumulatedPath), (int)0);
                return selection;
            }
            if (nextSegmentResource != null && nextSegmentResource.exists()) {
                selection = nextSegmentResource;
                continue;
            }
            nonExistingSegmentPaths.add(accumulatedPath.makeRelativeTo(selection.getFullPath()));
        }
        if (nonExistingSegmentPaths.size() > 0 && (create = MessageDialog.open((int)3, (Shell)this.getShell(), (String)NON_EXISTING_MODULE_LOCATION_TITLE, (String)NON_EXISTING_MODULE_LOCATION_MESSAGE, (int)0))) {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.open();
            IProgressMonitor progressMonitor = progressMonitorDialog.getProgressMonitor();
            IPath deepestPath = (IPath)nonExistingSegmentPaths.get(nonExistingSegmentPaths.size() - 1);
            selection = this.createFolderPath(deepestPath, selection, progressMonitor);
            progressMonitor.done();
            progressMonitorDialog.close();
        }
        return selection;
    }

    private IFolder createFolder(String name, IContainer parent, IProgressMonitor monitor) throws CoreException {
        IFolder folder = parent.getFolder((IPath)new Path(name));
        folder.create(true, true, monitor);
        return folder;
    }

    private IContainer createFolderPath(IPath path, IContainer parent, IProgressMonitor monitor) {
        IContainer activeContainer = parent;
        if (monitor != null) {
            monitor.beginTask("Creating folders", path.segmentCount());
        }
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            IFolder folderToCreate = activeContainer.getFolder((IPath)new Path(segment));
            try {
                if (!folderToCreate.exists()) {
                    this.createFolder(segment, activeContainer, monitor);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                activeContainer = folderToCreate;
            }
            catch (CoreException e) {
                LOGGER.error((Object)"Failed to create module folders.", (Throwable)e);
                MessageDialog.open((int)1, (Shell)this.getShell(), (String)FAILED_TO_CREATE_FOLDER_TITLE, (String)String.format(FAILED_TO_CREATE_FOLDER_MESSAGE, folderToCreate.getFullPath().toString(), e.getMessage()), (int)0);
                break;
            }
            ++n2;
        }
        return activeContainer;
    }

    private static boolean isModuleFileSpecifier(IPath path) {
        if (path.segmentCount() < 1) {
            return false;
        }
        String stringPath = path.toString();
        return stringPath.charAt(stringPath.length() - 1) != '/';
    }

    private void updateFileExtension() {
        Object selection = this.treeViewer.getStructuredSelection().getFirstElement();
        String elementFileName = this.elementNameInput.getText();
        if (selection == null) {
            this.setFileExtension(this.defaultFileExtension);
        }
        if (selection instanceof IFile && elementFileName.equals(((IFile)selection).getName())) {
            this.setFileExtension(((IFile)selection).getFileExtension());
        } else if (selection instanceof IResource) {
            IPath basepath = selection instanceof IFile ? ((IFile)selection).getParent().getFullPath() : ((IResource)selection).getFullPath();
            IPath pathOfSelection = basepath.append(elementFileName);
            IFile n4jsFile = this.workspaceRoot.getFile(pathOfSelection.addFileExtension("n4js"));
            IFile n4jsdFile = this.workspaceRoot.getFile(pathOfSelection.addFileExtension("n4jsd"));
            if (n4jsdFile.exists()) {
                this.setFileExtension("n4jsd");
            } else if (n4jsFile.exists()) {
                this.setFileExtension("n4js");
            } else {
                this.setFileExtension(this.defaultFileExtension);
            }
        }
    }

    private void setFileExtension(String fileExtension) {
        this.elementNameInput.setSuffix("." + fileExtension);
    }

    private IPath sourceFolderRelativePath(IResource resource) {
        IPath path = resource.getFullPath().makeRelativeTo(this.sourceFolder.getFullPath());
        if (path.toString().equals(Character.toString('/'))) {
            return new Path("");
        }
        return path;
    }

    private static String convertToUnixPath(String path) {
        return path.replaceAll("[\\\\]", "/");
    }

    private static class ModuleFolderFilter
    extends ViewerFilter {
        private final IPath prefix;

        public ModuleFolderFilter(IPath prefix) {
            this.prefix = prefix;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IContainer) {
                IPath p = ((IContainer)element).getFullPath();
                return this.prefix.isPrefixOf(p);
            }
            if (element instanceof IFile) {
                IPath p = ((IFile)element).getFullPath();
                return this.isN4JSResource(p) && this.prefix.isPrefixOf(p);
            }
            return false;
        }

        private boolean isN4JSResource(IPath path) {
            String fileExtension = path.getFileExtension();
            return fileExtension != null && (fileExtension.equals("n4js") || fileExtension.equals("n4jsd"));
        }
    }

    private static final class ModuleFolderValidator
    implements IInputValidator {
        private ModuleFolderValidator() {
        }

        public String isValid(String text) {
            String textToValidate = text;
            if (OSInfo.isWindows()) {
                textToValidate = ModuleSpecifierSelectionDialog.convertToUnixPath(text);
            }
            if (textToValidate.isEmpty()) {
                return "The module folder must not be empty";
            }
            if (!WorkspaceWizardValidatorUtils.isValidFolderPath((IPath)new Path(textToValidate))) {
                return "The module name is not a valid file system name";
            }
            return null;
        }
    }

    private final class ModuleSpecifierValidator
    implements IInputValidator {
        private ModuleSpecifierValidator() {
        }

        public String isValid(String newText) {
            Path path = new Path(newText);
            String fileExtension = path.getFileExtension();
            String moduleName = path.removeFileExtension().lastSegment();
            if (path.removeFileExtension().segmentCount() < 1 || moduleName.isEmpty()) {
                return "The module name must not be empty.";
            }
            if (!WorkspaceWizardValidatorUtils.isValidFolderName(path.removeFileExtension().toString())) {
                return "The module name is not a valid file system name.";
            }
            if (fileExtension == null) {
                return "The module name needs to have a valid N4JS file extension.";
            }
            if (!fileExtension.equals("n4js") && !fileExtension.equals("n4jsd")) {
                return "Invalid file extension.";
            }
            if (!ModuleSpecifierSelectionDialog.isModuleFileSpecifier((IPath)path)) {
                return "Invalid module file specifier.";
            }
            if (path.segmentCount() > 1) {
                return "/ is not allowed in a module file specifier.";
            }
            if (ModuleSpecifierSelectionDialog.this.treeViewer.getStructuredSelection().getFirstElement() == null) {
                return "Please select a module container";
            }
            return null;
        }
    }
}

