/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectModel.names;

import com.google.common.base.Preconditions;
import org.eclipse.n4js.projectModel.names.EclipseProjectName;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;

public final class N4JSProjectName
implements Comparable<N4JSProjectName> {
    private final String name;

    public N4JSProjectName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((name.indexOf(58) < 0 ? 1 : 0) != 0, (Object)name);
    }

    public String getName() {
        return ProjectDescriptionUtils.getPlainProjectName(this.name);
    }

    public String getScope() {
        return ProjectDescriptionUtils.getScopeName(this.name);
    }

    public String getRawName() {
        return this.name;
    }

    public EclipseProjectName toEclipseProjectName() {
        return new EclipseProjectName(ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName(this.name));
    }

    public boolean isEmpty() {
        return this.name.isEmpty();
    }

    @Override
    public int compareTo(N4JSProjectName o) {
        return this.name.compareTo(o.getRawName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            throw new IllegalArgumentException("Cannot compare to type " + obj.getClass().getName());
        }
        N4JSProjectName other = (N4JSProjectName)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }
}

