/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class N4JSModuleValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;
    @Inject
    private IContainer.Manager containerManager;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IN4JSCore n4jscore;
    private static final Pattern nonEmpty = Pattern.compile("^.+$", 8);

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkModuleSpecifier(Script script) {
        ResourceType resType = ResourceType.getResourceType(script.getModule().eResource());
        boolean correctType = resType == ResourceType.N4JS || resType == ResourceType.N4JSD || resType == ResourceType.N4JSX;
        String moduleQN = script.getModule().getQualifiedName();
        if (moduleQN.equals("js.cookie") || moduleQN.endsWith("/js.cookie")) {
            return;
        }
        if (correctType && moduleQN.contains(".")) {
            QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(moduleQN);
            boolean filenameContainsDot = qualifiedName.getLastSegment().contains(".");
            Functions.Function1 _function = s -> s.contains(".");
            String _findFirst = (String)IterableExtensions.findFirst((Iterable)qualifiedName.skipLast(1).getSegments(), (Functions.Function1)_function);
            boolean moduleFoldersContainDot = _findFirst != null;
            ArrayList locationSubject = CollectionLiterals.newArrayList();
            if (filenameContainsDot) {
                locationSubject.add("filename");
            }
            if (moduleFoldersContainDot) {
                locationSubject.add("containing folders");
            }
            String locationSubjectDescription = StringExtensions.toFirstUpper((String)IterableExtensions.join((Iterable)locationSubject, (CharSequence)" and "));
            this.addIssue(IssueCodes.getMessageForMOD_NAME_MUST_NOT_CONTAIN_DOTS(locationSubjectDescription, script.getModule().getQualifiedName()), (EObject)script, 0, 0, "MOD_NAME_MUST_NOT_CONTAIN_DOTS");
        }
    }

    @Check
    public void checkUniqueName(Script script) {
        boolean _notEquals;
        String _fileExtension = script.eResource().getURI().fileExtension();
        boolean bl = _notEquals = !Objects.equal((Object)_fileExtension, (Object)"js");
        if (_notEquals) {
            this.checkUniqueName(script, script.getModule());
        }
    }

    private void checkUniqueName(Script script, TModule module) {
        if (module == null) {
            return;
        }
        QualifiedName name = this.qualifiedNameConverter.toQualifiedName(module.getQualifiedName());
        if (name != null) {
            this.doCheckUniqueName(script, module, name);
        }
    }

    private void doCheckUniqueName(Script script, TModule module, QualifiedName name) {
        Resource _eResource = module.eResource();
        XtextResource resource = (XtextResource)_eResource;
        IResourceDescriptions index = this.resourceDescriptionsProvider.getResourceDescriptions((Resource)resource);
        Iterable others = index.getExportedObjects(TypesPackage.Literals.TMODULE, name, false);
        Provider _function = () -> {
            IResourceDescription _resourceDescription_1;
            IResourceDescription _elvis = null;
            IResourceDescription _resourceDescription = index.getResourceDescription(resource.getURI());
            _elvis = _resourceDescription != null ? _resourceDescription : (_resourceDescription_1 = this.resourceDescriptionManager.getResourceDescription((Resource)resource));
            IResourceDescription description = _elvis;
            if (description == null) {
                return CollectionLiterals.emptyList();
            }
            return this.containerManager.getVisibleContainers(description, index);
        };
        this.checkUniqueInIndex(script, module, others, (Provider<List<IContainer>>)_function);
    }

    private void checkUniqueInIndex(Script script, TModule module, Iterable<IEObjectDescription> descriptions, Provider<List<IContainer>> lazyContainersList) {
        boolean _greaterThan;
        Functions.Function1 _function = it -> it.getEObjectURI().trimFragment();
        Functions.Function1 _function_1 = it -> !Objects.equal((Object)it, (Object)EcoreUtil2.getPlatformResourceOrNormalizedURI((Resource)module.eResource())) && !Objects.equal((Object)it.fileExtension(), (Object)"js");
        Set resourceURIs = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map(descriptions, (Functions.Function1)_function), (Functions.Function1)_function_1));
        int _size = resourceURIs.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _greaterThan_1;
            HashSet visibleResourceURIs = CollectionLiterals.newHashSet();
            Consumer<IContainer> _function_2 = container -> {
                Functions.Function1 _function_3 = uri -> container.hasResourceDescription(uri);
                Iterable _filter = IterableExtensions.filter((Iterable)resourceURIs, (Functions.Function1)_function_3);
                Iterables.addAll((Collection)visibleResourceURIs, (Iterable)_filter);
            };
            ((List)lazyContainersList.get()).forEach(_function_2);
            int _size_1 = visibleResourceURIs.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                boolean _isEmpty;
                boolean _isStaticPolyfillAware = module.isStaticPolyfillAware();
                if (_isStaticPolyfillAware) {
                    boolean _equals;
                    int _size_2 = visibleResourceURIs.size();
                    boolean bl3 = _equals = _size_2 == 1;
                    if (_equals) {
                        return;
                    }
                } else {
                    boolean _isStaticPolyfillModule = module.isStaticPolyfillModule();
                    if (_isStaticPolyfillModule) {
                        boolean _equals_1;
                        int _size_3 = visibleResourceURIs.size();
                        boolean bl4 = _equals_1 = _size_3 == 1;
                        if (_equals_1) {
                            return;
                        }
                    }
                }
                if (this.hasPolyfill(script) && !module.isStaticPolyfillModule()) {
                    return;
                }
                Set filteredMutVisibleResourceURIs = visibleResourceURIs;
                boolean _isMainModule = module.isMainModule();
                if (_isMainModule) {
                    IN4JSProject pr = (IN4JSProject)this.n4jscore.findProject(module.eResource().getURI()).get();
                    Functions.Function1 _function_3 = u -> {
                        IN4JSProject _get = (IN4JSProject)this.n4jscore.findProject((URI)u).get();
                        boolean _equals_2 = Objects.equal((Object)pr, (Object)_get);
                        if (_equals_2) {
                            String baseModuleSrcCon = ((IN4JSSourceContainer)this.n4jscore.findN4JSSourceContainer(module.eResource().getURI()).get()).getLocation().toString();
                            String otherModuleSrcCon = ((IN4JSSourceContainer)this.n4jscore.findN4JSSourceContainer((URI)u).get()).getLocation().toString();
                            String baseModuleSrcContainerRelativePath = module.eResource().getURI().toString().substring(baseModuleSrcCon.length());
                            String otherModuleSrcContainerRelativePath = u.toString().substring(otherModuleSrcCon.length());
                            return Objects.equal((Object)baseModuleSrcContainerRelativePath, (Object)otherModuleSrcContainerRelativePath);
                        }
                        return false;
                    };
                    filteredMutVisibleResourceURIs = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)filteredMutVisibleResourceURIs, (Functions.Function1)_function_3));
                }
                if (_isEmpty = filteredMutVisibleResourceURIs.isEmpty()) {
                    return;
                }
                Functions.Function1 _function_4 = it -> IterableExtensions.join((Iterable)IterableExtensions.drop((Iterable)it.segmentsList(), (int)1), (CharSequence)"/");
                String filePathStr = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)filteredMutVisibleResourceURIs, (Functions.Function1)_function_4), (CharSequence)"; ");
                String message = IssueCodes.getMessageForCLF_DUP_MODULE(module.getQualifiedName(), filePathStr);
                this.addIssue(message, script, "CLF_DUP_MODULE");
            }
        }
    }

    private boolean hasPolyfill(Script script) {
        EList _scriptElements = script.getScriptElements();
        for (ScriptElement se : _scriptElements) {
            boolean _matched = false;
            if (!(se instanceof AnnotableElement)) continue;
            _matched = true;
            boolean _isPolyfill = N4JSLanguageUtils.isPolyfill((AnnotableElement)se);
            if (!_isPolyfill) continue;
            return true;
        }
        return false;
    }

    private void addIssue(String message, Script script, String issueCode) {
        ScriptElement first = (ScriptElement)IterableExtensions.head((Iterable)script.getScriptElements());
        if (first != null) {
            this.addIssue(message, (EObject)first, issueCode);
            return;
        }
        Resource _eResource = script.eResource();
        XtextResource resource = (XtextResource)_eResource;
        IParseResult parseResult = resource.getParseResult();
        ICompositeNode rootNode = parseResult.getRootNode();
        String text = rootNode.getText();
        Matcher matcher = nonEmpty.matcher(text);
        int start = 0;
        int end = text.length();
        boolean _find = matcher.find();
        if (_find) {
            start = matcher.start();
            end = matcher.end();
        }
        this.addIssue(message, (EObject)script, start, end - start, issueCode);
    }
}

