/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.converters;

import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.e4.ui.css.core.dom.properties.converters.AbstractCSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverterConfig;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.exceptions.DOMExceptionImpl;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class CSSValueSWTColorConverterImpl
extends AbstractCSSValueConverter {
    public static final ICSSValueConverter INSTANCE = new CSSValueSWTColorConverterImpl();

    public CSSValueSWTColorConverterImpl() {
        super(Color.class);
    }

    public Color convert(CSSValue value, CSSEngine engine, Object context) throws DOMException {
        Display display = (Display)context;
        Color color = CSSSWTColorHelper.getSWTColor(value, display);
        if (color == null) {
            throw new DOMExceptionImpl(15, 14);
        }
        return color;
    }

    public String convert(Object value, CSSEngine engine, Object context, ICSSValueConverterConfig config) throws Exception {
        Color color = (Color)value;
        RGBColor rgbColor = CSSSWTColorHelper.getRGBColor(color);
        return CSS2ColorHelper.getColorStringValue((RGBColor)rgbColor, (ICSSValueConverterConfig)config);
    }
}

