/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.N4jscTestFactory;
import org.eclipse.n4js.cli.compiler.N4jscCompiler;
import org.eclipse.n4js.cli.helper.AbstractCliTest;
import org.eclipse.n4js.cli.helper.CliResult;
import org.eclipse.n4js.cli.helper.GeneratedJSFilesCounter;
import org.eclipse.n4js.cli.helper.N4CliHelper;
import org.eclipse.n4js.cli.runner.helper.NodejsExecuter;
import org.eclipse.n4js.cli.runner.helper.NodejsResult;
import org.eclipse.n4js.ide.server.N4JSWorkspaceManager;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.utils.io.FileUtils;
import org.eclipse.xtext.util.Arrays;
import org.eclipse.xtext.workspace.IProjectConfig;

public class AbstractCliCompileTest
extends AbstractCliTest<N4jscOptions> {
    private static final String WSP = "wsp";
    protected static final String PACKAGES = "packages";
    protected static final String FIXTURE = "probands";
    protected static final String TEST_DATA_SET__BASIC = "basic";
    protected static final String TEST_DATA_SET__TESTERS = "testers";
    protected static final String TEST_DATA_SET__NPM_SCOPES = "npmScopes";

    @Override
    public void doMain(N4jscOptions options, CliResult result) throws Exception {
        N4jscCompiler.start((N4jscOptions)options);
        File workspaceRoot = (File)options.getSrcFiles().get(0);
        result.transpiledFiles = GeneratedJSFilesCounter.getTranspiledFiles(workspaceRoot.toPath());
        Injector lastInjector = N4jscTestFactory.getLastCreatedInjector();
        N4JSWorkspaceManager workspaceManager = (N4JSWorkspaceManager)lastInjector.getInstance(N4JSWorkspaceManager.class);
        Set projects = workspaceManager.getWorkspaceConfig().getProjects();
        TreeMap<String, String> projectMap = new TreeMap<String, String>();
        for (IProjectConfig pConfig : projects) {
            Path projectPath = Path.of(pConfig.getPath().toFileString(), new String[0]);
            Path relativeProjectPath = workspaceRoot.toPath().relativize(projectPath);
            projectMap.put(pConfig.getName(), relativeProjectPath.toString());
        }
        result.projects = projectMap;
    }

    public NodejsResult run(Path workingDir, Path runFile) {
        Injector lastInjector = N4jscTestFactory.getLastCreatedInjector();
        NodejsExecuter nodejsExecuter = new NodejsExecuter(lastInjector);
        return nodejsExecuter.run(workingDir, runFile);
    }

    protected static File setupWorkspace(String testDataSet, boolean createYarnWorkspace) throws IOException {
        return AbstractCliCompileTest.setupWorkspace(testDataSet, (Predicate<N4JSProjectName>)Predicates.alwaysFalse(), createYarnWorkspace);
    }

    protected static File setupWorkspace(String testDataRoot, String testDataSet, boolean createYarnWorkspace) throws IOException {
        return AbstractCliCompileTest.setupWorkspace(testDataRoot, testDataSet, (Predicate<N4JSProjectName>)Predicates.alwaysFalse(), createYarnWorkspace);
    }

    protected static File setupWorkspace(String testDataSet, boolean createYarnWorkspace, N4JSProjectName ... libNames) throws IOException {
        return AbstractCliCompileTest.setupWorkspace(testDataSet, (Predicate<N4JSProjectName>)((Predicate)libName -> Arrays.contains((Object[])libNames, (Object)libName)), createYarnWorkspace);
    }

    protected static File setupWorkspace(String testDataSet, Predicate<N4JSProjectName> n4jsLibrariesPredicate, boolean createYarnWorkspace) throws IOException {
        return AbstractCliCompileTest.setupWorkspace(FIXTURE, testDataSet, n4jsLibrariesPredicate, createYarnWorkspace);
    }

    private static File setupWorkspace(String testDataRoot, String testDataSet, Predicate<N4JSProjectName> n4jsLibrariesPredicate, boolean createYarnWorkspace) throws IOException {
        Path fixture = new File(testDataRoot, testDataSet).toPath();
        Path root = FileUtils.createTempDirectory((String)(String.valueOf(testDataRoot) + "_" + testDataSet + "_"));
        Path wsp = root.resolve(WSP);
        N4CliHelper.setupWorkspace(fixture, wsp, n4jsLibrariesPredicate, createYarnWorkspace);
        return wsp.toFile();
    }
}

