/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.hover;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.ide.server.hover.CustomHoverLabelUtil;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtend2.lib.StringConcatenation;

public class N4JSElementSignatureProvider {
    @Inject
    private N4JSTypeSystem ts;

    public String get(EObject o) {
        if (o instanceof LiteralOrComputedPropertyName) {
            return this.get(((LiteralOrComputedPropertyName)o).eContainer());
        }
        EObject id = this.getIdentifiableElement(o);
        String label = this.doGetLabel(id, o);
        UtilN4.sanitizeForHTML((String)label);
        return label;
    }

    private EObject getIdentifiableElement(EObject o) {
        IdentifiableElement _switchResult = null;
        boolean _matched = false;
        if (o instanceof IdentifierRef) {
            _matched = true;
            _switchResult = ((IdentifierRef)o).getId();
        }
        if (!_matched && o instanceof ParameterizedPropertyAccessExpression) {
            _matched = true;
            _switchResult = ((ParameterizedPropertyAccessExpression)o).getProperty();
        }
        if (!_matched && o instanceof LiteralOrComputedPropertyName) {
            _matched = true;
            _switchResult = ((LiteralOrComputedPropertyName)o).eContainer();
        }
        if (!_matched) {
            _switchResult = o;
        }
        IdentifiableElement result = _switchResult;
        return result;
    }

    private String _doGetLabel(EObject o, EObject ref) {
        EObject tElem = N4JSASTUtils.getCorrespondingTypeModelElement((EObject)o);
        return CustomHoverLabelUtil.getLabel((EObject)tElem);
    }

    private String _doGetLabel(IdentifierRef ir, EObject ref) {
        return this.getLabelFromTypeSystem((TypableElement)ir, (EObject)ir);
    }

    private String _doGetLabel(TVariable tv, EObject ref) {
        return this.getLabelFromTypeSystem((TypableElement)tv, ref);
    }

    private String _doGetLabel(ParameterizedPropertyAccessExpression ppae, EObject ref) {
        return this.getLabelFromTypeSystem((TypableElement)ppae, (EObject)ppae);
    }

    private String _doGetLabel(VariableDeclaration vd, EObject ref) {
        String _xifexpression = null;
        _xifexpression = vd instanceof ExportedVariableDeclaration ? this._doGetLabel((EObject)vd, ref) : this.getLabelFromTypeSystem((TypableElement)vd, ref);
        return _xifexpression;
    }

    private String _doGetLabel(PropertyNameValuePair nameValuePair, EObject ref) {
        return this.getLabelFromTypeSystem((TypableElement)nameValuePair, ref);
    }

    private String _doGetLabel(FormalParameter fp, EObject ref) {
        String _xblockexpression = null;
        String _xifexpression = null;
        boolean _isHasInitializerAssignment = fp.isHasInitializerAssignment();
        _xifexpression = _isHasInitializerAssignment ? "=\u2026" : "";
        String optinonalMarker = _xifexpression;
        String _labelFromTypeSystem = this.getLabelFromTypeSystem((TypableElement)fp, ref);
        _xblockexpression = String.valueOf(_labelFromTypeSystem) + optinonalMarker;
        return _xblockexpression;
    }

    private String _doGetLabel(FunctionExpression fe, EObject ref) {
        return this.getLabelFromTypeSystem((TypableElement)fe, ref);
    }

    private String _doGetLabel(LiteralOrComputedPropertyName name, EObject ref) {
        EObject _eContainer = name.eContainer();
        if (_eContainer instanceof TypableElement) {
            EObject _eContainer_1 = name.eContainer();
            return this.getLabelFromTypeSystem((TypableElement)_eContainer_1, ref);
        }
        return name.getName();
    }

    private String getLabelFromTypeSystem(TypableElement o, EObject ref) {
        if (o == null || o.eResource() == null) {
            return null;
        }
        TypableElement _xifexpression = null;
        _xifexpression = ref instanceof TypableElement ? (TypableElement)ref : o;
        TypableElement elem = _xifexpression;
        TypeRef typeRef = this.ts.type(RuleEnvironmentExtensions.newRuleEnvironment((EObject)elem), elem);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _name = this.getName((EObject)o);
        _builder.append((Object)_name);
        _builder.append(": ");
        String _typeRefAsString = typeRef.getTypeRefAsString();
        _builder.append(_typeRefAsString);
        return _builder.toString();
    }

    private CharSequence _getName(EObject o) {
        return "";
    }

    private CharSequence _getName(NamedElement namedElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        String _name = namedElement.getName();
        _builder.append(_name, " ");
        return _builder;
    }

    private CharSequence _getName(IdentifiableElement identifiableElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        String _name = identifiableElement.getName();
        _builder.append(_name, " ");
        return _builder;
    }

    private CharSequence _getName(TVariable tVariable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        String _xifexpression = null;
        boolean _isConst = tVariable.isConst();
        _xifexpression = _isConst ? "const" : "var";
        _builder.append(_xifexpression, " ");
        _builder.append(" ");
        String _name = tVariable.getName();
        _builder.append(_name, " ");
        return _builder;
    }

    private String doGetLabel(EObject nameValuePair, EObject ref) {
        if (nameValuePair instanceof PropertyNameValuePair) {
            return this._doGetLabel((PropertyNameValuePair)nameValuePair, ref);
        }
        if (nameValuePair instanceof FormalParameter) {
            return this._doGetLabel((FormalParameter)nameValuePair, ref);
        }
        if (nameValuePair instanceof FunctionExpression) {
            return this._doGetLabel((FunctionExpression)nameValuePair, ref);
        }
        if (nameValuePair instanceof IdentifierRef) {
            return this._doGetLabel((IdentifierRef)nameValuePair, ref);
        }
        if (nameValuePair instanceof ParameterizedPropertyAccessExpression) {
            return this._doGetLabel((ParameterizedPropertyAccessExpression)nameValuePair, ref);
        }
        if (nameValuePair instanceof VariableDeclaration) {
            return this._doGetLabel((VariableDeclaration)nameValuePair, ref);
        }
        if (nameValuePair instanceof TVariable) {
            return this._doGetLabel((TVariable)nameValuePair, ref);
        }
        if (nameValuePair instanceof LiteralOrComputedPropertyName) {
            return this._doGetLabel((LiteralOrComputedPropertyName)nameValuePair, ref);
        }
        if (nameValuePair != null) {
            return this._doGetLabel(nameValuePair, ref);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(nameValuePair, ref).toString());
    }

    private CharSequence getName(EObject tVariable) {
        if (tVariable instanceof TVariable) {
            return this._getName((TVariable)tVariable);
        }
        if (tVariable instanceof IdentifiableElement) {
            return this._getName((IdentifiableElement)tVariable);
        }
        if (tVariable instanceof NamedElement) {
            return this._getName((NamedElement)tVariable);
        }
        if (tVariable != null) {
            return this._getName(tVariable);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tVariable).toString());
    }
}

