/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.build;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;

public class XSource2GeneratedMapping
implements Externalizable {
    private final Multimap<URI, URI> source2generated;
    private final Multimap<URI, URI> generated2source;
    private final Map<URI, String> generated2OutputConfigName;

    public XSource2GeneratedMapping() {
        this((Multimap<URI, URI>)HashMultimap.create(), (Multimap<URI, URI>)HashMultimap.create(), new HashMap<URI, String>());
    }

    public XSource2GeneratedMapping(Multimap<URI, URI> source2generated, Multimap<URI, URI> generated2source, Map<URI, String> generated2OutputConfigName) {
        this.source2generated = source2generated;
        this.generated2source = generated2source;
        this.generated2OutputConfigName = generated2OutputConfigName;
    }

    public XSource2GeneratedMapping copy() {
        return new XSource2GeneratedMapping((Multimap<URI, URI>)HashMultimap.create(this.source2generated), (Multimap<URI, URI>)HashMultimap.create(this.generated2source), new HashMap<URI, String>(this.generated2OutputConfigName));
    }

    public void addSource2Generated(URI source, URI generated) {
        this.addSource2Generated(source, generated, "DEFAULT_OUTPUT");
    }

    public void addSource2Generated(URI source, URI generated, String outputCfgName) {
        this.source2generated.put((Object)source, (Object)generated);
        this.generated2source.put((Object)generated, (Object)source);
        this.generated2OutputConfigName.put(generated, outputCfgName == null ? "DEFAULT_OUTPUT" : outputCfgName);
    }

    public void removeSource2Generated(URI source, URI generated) {
        this.source2generated.remove((Object)source, (Object)generated);
        this.generated2source.remove((Object)generated, (Object)source);
        if (!this.generated2source.containsKey((Object)generated)) {
            this.generated2OutputConfigName.remove(generated);
        }
    }

    public Set<URI> deleteSource(URI source) {
        HashSet<URI> generated = new HashSet<URI>(this.source2generated.removeAll((Object)source));
        for (URI gen : generated) {
            this.generated2source.remove((Object)gen, (Object)source);
            if (this.generated2source.containsKey((Object)gen)) continue;
            this.generated2OutputConfigName.remove(gen);
        }
        return generated;
    }

    public void deleteGenerated(URI generated) {
        this.generated2source.removeAll((Object)generated).forEach(it -> this.source2generated.remove(it, (Object)generated));
        this.generated2OutputConfigName.remove(generated);
    }

    public String getOutputConfigName(URI generated) {
        return this.generated2OutputConfigName.get(generated);
    }

    public List<URI> getGenerated(URI source) {
        return new ArrayList<URI>(this.source2generated.get((Object)source));
    }

    public List<URI> getSource(URI generated) {
        return new ArrayList<URI>(this.generated2source.get((Object)generated));
    }

    public List<URI> getAllGenerated() {
        return new ArrayList<URI>(this.generated2source.keySet());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int numEntries = in.readInt();
        while (numEntries > 0) {
            --numEntries;
            URI source = URI.createURI((String)in.readUTF());
            int numGenerated = in.readInt();
            while (numGenerated > 0) {
                --numGenerated;
                URI generated = URI.createURI((String)in.readUTF());
                String outputConfig = in.readUTF();
                this.addSource2Generated(source, generated, outputConfig);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Set entries = this.source2generated.asMap().entrySet();
        out.writeInt(entries.size());
        for (Map.Entry it : entries) {
            out.writeUTF(((URI)it.getKey()).toString());
            out.writeInt(((Collection)it.getValue()).size());
            for (URI value : (Collection)it.getValue()) {
                out.writeUTF(value.toString());
                out.writeUTF(this.generated2OutputConfigName.get(value));
            }
        }
    }
}

