/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries.nodejs;

import com.google.common.base.StandardSystemProperty;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.BinariesConstants;
import org.eclipse.n4js.binaries.BinariesValidator;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.semver.Semver.VersionNumber;

@Singleton
public class NpmrcBinary
extends Binary {
    private static final String NPM_CONFIG_USERCONFIG = "NPM_CONFIG_userconfig";
    private String memoizedCalculatedNpmrcPath = null;
    @Inject
    private BinariesValidator validator;
    @Inject
    private Provider<NpmBinary> npmBinaryProvider;

    @Override
    public String getId() {
        return NpmrcBinary.class.getName();
    }

    @Override
    public String getLabel() {
        return "npmrc";
    }

    @Override
    public String getDescription() {
        return "Configuration of the folder location of the .npmrc file can be provided here. If not given, then the location will be resolved to '" + this.getDefaultNpmrcPath() + "'. The required minimum version npm is '" + BinariesConstants.NPM_MIN_VERSION + "'.";
    }

    @Override
    public VersionNumber getMinimumVersion() {
        return null;
    }

    @Override
    public String getBinaryDirectory() {
        return this.getUserNodePathOrDefault();
    }

    @Override
    public String getBinaryFileName() {
        return ".npmrc";
    }

    @Override
    public String getVersionArgument() {
        return "-v";
    }

    @Override
    public Binary getParent() {
        return (Binary)this.npmBinaryProvider.get();
    }

    @Override
    public Map<String, String> updateEnvironment(Map<String, String> environment) {
        String actualPathPropertyName = this.findActualPropertyNameOrDefault(environment, NPM_CONFIG_USERCONFIG);
        String additionalNodePath = String.valueOf(this.getUserNodePathOrDefault()) + File.separator + ".npmrc";
        environment.put(actualPathPropertyName, additionalNodePath);
        return environment;
    }

    @Override
    public IStatus validate() {
        IStatus parentStatus;
        Binary parent = this.getParent();
        if (parent != null && !(parentStatus = parent.validate()).isOK()) {
            return parentStatus;
        }
        return this.validator.binaryExists(this);
    }

    String getUserNodePathOrDefault() {
        URI userConfiguredLocation = this.getUserConfiguredLocation();
        return userConfiguredLocation == null ? this.getDefaultNpmrcPath() : new File(userConfiguredLocation).getAbsolutePath();
    }

    private String getDefaultNpmrcPath() {
        if (this.memoizedCalculatedNpmrcPath == null) {
            this.memoizedCalculatedNpmrcPath = StandardSystemProperty.USER_HOME.value();
        }
        return this.memoizedCalculatedNpmrcPath;
    }
}

