/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import org.eclipse.n4js.projectDescription.SourceContainerType;

abstract class AbstractSourceContainer {
    private final SourceContainerType type;
    private final String relativeLocation;

    protected AbstractSourceContainer(SourceContainerType type, String relativeLocation) {
        this.type = type;
        switch (type) {
            case SOURCE: 
            case TEST: 
            case EXTERNAL: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(type));
            }
        }
        this.relativeLocation = relativeLocation;
    }

    public boolean isTest() {
        return this.type == SourceContainerType.TEST;
    }

    public boolean isSource() {
        return this.type == SourceContainerType.SOURCE;
    }

    public boolean isExternal() {
        return this.type == SourceContainerType.EXTERNAL;
    }

    public String getRelativeLocation() {
        return this.relativeLocation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.relativeLocation == null ? 0 : this.relativeLocation.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractSourceContainer)) {
            return false;
        }
        AbstractSourceContainer other = (AbstractSourceContainer)obj;
        if (this.relativeLocation == null ? other.relativeLocation != null : !this.relativeLocation.equals(other.relativeLocation)) {
            return false;
        }
        return this.type == other.type;
    }

    public boolean exists() {
        return true;
    }
}

