/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal.lsp;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.lsp.N4JSSourceFolder;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.lsp.IN4JSProjectConfig;
import org.eclipse.n4js.projectModel.lsp.IN4JSSourceFolder;
import org.eclipse.n4js.projectModel.lsp.IN4JSWorkspaceConfig;

public class N4JSProjectConfig
implements IN4JSProjectConfig {
    private final IN4JSWorkspaceConfig workspace;
    private final IN4JSProject delegate;

    public N4JSProjectConfig(IN4JSWorkspaceConfig workspace, IN4JSProject delegate) {
        this.workspace = workspace;
        this.delegate = delegate;
    }

    public String getName() {
        return this.delegate.getProjectName().getRawName();
    }

    @Override
    public IN4JSProject toProject() {
        return this.delegate;
    }

    public URI getPath() {
        return ((SafeURI)this.delegate.getLocation().withTrailingPathDelimiter()).toURI();
    }

    @Override
    public Set<? extends IN4JSSourceFolder> getSourceFolders() {
        LinkedHashSet<SourceContainerForPackageJson> sourceFolders = new LinkedHashSet<SourceContainerForPackageJson>();
        this.delegate.getSourceContainers().forEach(container -> {
            boolean bl = sourceFolders.add((SourceContainerForPackageJson)((Object)new N4JSSourceFolder(this, (IN4JSSourceContainer)container)));
        });
        sourceFolders.add(new SourceContainerForPackageJson());
        return sourceFolders;
    }

    @Override
    public IN4JSSourceFolder findSourceFolderContaining(URI member) {
        IN4JSSourceContainer sourceContainer = this.delegate.findSourceContainerWith(member);
        if (sourceContainer == null) {
            return null;
        }
        return new N4JSSourceFolder(this, sourceContainer);
    }

    public List<URI> getOutputFolders() {
        return Collections.singletonList(((SafeURI)this.delegate.getLocation().appendPath(this.delegate.getOutputPath())).toURI());
    }

    @Override
    public IN4JSWorkspaceConfig getWorkspaceConfig() {
        return this.workspace;
    }

    private class SourceContainerForPackageJson
    implements IN4JSSourceFolder {
        private SourceContainerForPackageJson() {
        }

        public String getName() {
            return "package.json";
        }

        @Override
        public List<URI> getAllResources() {
            return Collections.singletonList(((SafeURI)N4JSProjectConfig.this.delegate.getLocation().appendSegment("package.json")).toURI());
        }

        @Override
        public IN4JSProjectConfig getProject() {
            return N4JSProjectConfig.this;
        }

        @Override
        public boolean contains(URI uri) {
            return this.getAllResources().contains(uri);
        }

        public URI getPath() {
            return N4JSProjectConfig.this.delegate.getLocation().toURI();
        }
    }
}

