/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import java.util.List;
import org.eclipse.n4js.scoping.members.ComposedMemberInfo;
import org.eclipse.n4js.scoping.members.MemberFactory;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;

abstract class GetterFactory
implements MemberFactory {
    final ComposedMemberInfo cma;

    GetterFactory(ComposedMemberInfo cma) {
        this.cma = cma;
    }

    abstract MemberAccessModifier getAccessability();

    abstract TypeRef getReturnTypeRefComposition();

    @Override
    public boolean isValid() {
        return true;
    }

    public TGetter create(String name) {
        TGetter getter = TypesFactory.eINSTANCE.createTGetter();
        getter.setComposed(true);
        TypeRef typeRef = this.getReturnTypeRefComposition();
        TypeUtils.setMemberTypeRef((TMember)getter, (TypeRef)typeRef);
        getter.setName(name);
        getter.setDeclaredMemberAccessModifier(this.getAccessability());
        return getter;
    }

    static class IntersectionGetterFactory
    extends GetterFactory {
        IntersectionGetterFactory(ComposedMemberInfo cma) {
            super(cma);
        }

        @Override
        MemberAccessModifier getAccessability() {
            return this.cma.getAccessabilityMax();
        }

        @Override
        TypeRef getReturnTypeRefComposition() {
            List<TypeRef> typeRefs = this.cma.getTypeRefsOfMemberType(MemberType.GETTER, MemberType.FIELD);
            return this.cma.getTypeSystem().createSimplifiedIntersection(typeRefs, this.cma.getResource());
        }

        @Override
        public List<TMember> getConstituentMembers() {
            return this.cma.getConstituentMembers();
        }
    }

    static class UnionGetterFactory
    extends GetterFactory {
        UnionGetterFactory(ComposedMemberInfo cma) {
            super(cma);
        }

        @Override
        MemberAccessModifier getAccessability() {
            return this.cma.getAccessabilityMin();
        }

        @Override
        TypeRef getReturnTypeRefComposition() {
            List<TypeRef> typeRefs = this.cma.getTypeRefsOfMemberType(MemberType.GETTER, MemberType.FIELD);
            return this.cma.getTypeSystem().createSimplifiedUnion(typeRefs, this.cma.getResource());
        }

        @Override
        public List<TMember> getConstituentMembers() {
            return this.cma.getConstituentMembers();
        }
    }
}

