/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetImpl;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;

public abstract class DefaultWorkingSetImpl
extends WorkingSetImpl
implements Predicate<IProject> {
    protected DefaultWorkingSetImpl(String id, WorkingSetManager manager) {
        super(id, manager);
    }

    @Override
    public IAdaptable[] getElements() {
        IProject[] projects = this.getAllProjects();
        if ("Other Projects".equals(this.getId())) {
            WorkingSet[] allWorkingSets = this.getWorkingSetManager().getAllWorkingSets();
            if (allWorkingSets.length == 1) {
                return projects;
            }
            FluentIterable others = FluentIterable.from(Arrays.asList(allWorkingSets)).filter(ws -> !"Other Projects".equals(ws.getId()));
            ImmutableMap elementMapping = Maps.toMap((Iterable)others, ws -> Sets.newHashSet((Object[])ws.getElements()));
            IProject[] elements = new IProject[projects.length];
            int elementCount = 0;
            int i = 0;
            int size = projects.length;
            while (i < size) {
                IProject project = projects[i];
                if (!Iterables.any((Iterable)others, arg_0 -> DefaultWorkingSetImpl.lambda$2((Map)elementMapping, project, arg_0))) {
                    elements[elementCount++] = project;
                }
                ++i;
            }
            return (IAdaptable[])Arrays.copyOfRange(elements, 0, elementCount);
        }
        IProject[] elements = new IProject[projects.length];
        int elementCount = 0;
        int i = 0;
        int size = projects.length;
        while (i < size) {
            IProject project = projects[i];
            if (this.apply(project)) {
                elements[elementCount++] = project;
            }
            ++i;
        }
        return (IAdaptable[])Arrays.copyOfRange(elements, 0, elementCount);
    }

    protected IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    private static /* synthetic */ boolean lambda$2(Map map, IProject iProject, WorkingSet ws) {
        return ((Collection)map.get(ws)).contains(iProject);
    }
}

