/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Control;

public class ElementSectionDragAdapter
extends DragSourceAdapter {
    private ISelectionProvider fSelectionProvider;
    private Object fDragData;

    public ElementSectionDragAdapter(ISelectionProvider provider) {
        this.fSelectionProvider = provider;
    }

    public void dragSetData(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (ModelDataTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getSelectedModelObjects();
            this.fDragData = event.data;
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.createTextualRepresentation((IStructuredSelection)this.fSelectionProvider.getSelection());
            this.fDragData = null;
            return;
        }
    }

    private String createTextualRepresentation(IStructuredSelection sel) {
        StringBuilder buf = new StringBuilder();
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            String name = iter.next().toString();
            buf.append(name);
            buf.append(" ");
        }
        return buf.toString();
    }

    public void dragStart(DragSourceEvent event) {
        DragSource dragSource = (DragSource)event.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            event.doit = false;
            return;
        }
        event.doit = this.canDrag();
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit || this.fDragData == null) {
            return;
        }
        this.fDragData = null;
    }

    private boolean canDrag() {
        return this.canCopy((IStructuredSelection)this.fSelectionProvider.getSelection());
    }

    private boolean canCopy(IStructuredSelection selection) {
        Object prev = null;
        for (Object obj : selection) {
            if (!(obj instanceof ISchemaObject)) {
                return false;
            }
            if (prev != null) {
                if (prev.getClass().equals(obj.getClass())) continue;
                return false;
            }
            prev = obj;
        }
        return true;
    }

    private ISchemaObject[] getSelectedModelObjects() {
        return this.createObjectRepresentation((IStructuredSelection)this.fSelectionProvider.getSelection());
    }

    private ISchemaObject[] createObjectRepresentation(IStructuredSelection selection) {
        ArrayList objects = new ArrayList();
        for (Object obj : selection) {
            if (obj instanceof ISchemaObject) {
                objects.add(obj);
                continue;
            }
            return new ISchemaObject[0];
        }
        return objects.toArray(new ISchemaObject[objects.size()]);
    }

    public Object[] getDragData() {
        if (this.fDragData instanceof Object[]) {
            return (Object[])this.fDragData;
        }
        return new Object[]{this.fDragData};
    }
}

