/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.organize.imports.ScriptDependencyResolver;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class SanitizeImportsTransformation
extends Transformation {
    public void analyze() {
    }

    public void assertPreConditions() {
        this.assertTrue("requires a fully resolved script", this.getState().im.isFlaggedUsageMarkingFinished());
    }

    public void assertPostConditions() {
        Functions.Function1 _function = it -> {
            boolean _isUsed = this.isUsed((ImportSpecifier)it);
            return !_isUsed;
        };
        List unusedImports = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)this.getState().im, ImportSpecifier.class), (Functions.Function1)_function));
        String _join = Joiner.on((String)",").join((Iterable)unusedImports);
        String _plus = "There should not be any unused import. Unused=" + _join;
        int _size = unusedImports.size();
        boolean _tripleEquals = _size == 0;
        this.assertTrue(_plus, _tripleEquals);
    }

    public void transform() {
        this.addMissingImplicitImports();
        this.removeUnusedImports();
    }

    private void addMissingImplicitImports() {
        Iterable requiresImport;
        Functions.Function1 _function = it -> it.getId_IM();
        Set referencedSTEs = IteratorExtensions.toSet((Iterator)Iterators.filter((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)this.getState().im.eAllContents(), IdentifierRef_IM.class), (Functions.Function1)_function), SymbolTableEntryOriginal.class));
        TModule baseModule = this.getState().resource.getModule();
        Functions.Function1 _function_1 = it -> ScriptDependencyResolver.shouldBeImported((TModule)baseModule, (EObject)it.getOriginalTarget());
        Iterable thingsToImportSTE = requiresImport = IterableExtensions.filter((Iterable)referencedSTEs, (Functions.Function1)_function_1);
        Consumer<SymbolTableEntryOriginal> _function_2 = ste -> {
            TModule module;
            boolean _hasAnnotation;
            IdentifiableElement orig;
            boolean _isExported;
            boolean _tripleEquals;
            ImportSpecifier _importSpecifier = ste.getImportSpecifier();
            boolean bl = _tripleEquals = _importSpecifier == null;
            if (_tripleEquals && (_isExported = N4JSLanguageUtils.isExported((IdentifiableElement)(orig = ste.getOriginalTarget()))) && (_hasAnnotation = AnnotationDefinition.GLOBAL.hasAnnotation((TAnnotableElement)(module = orig.getContainingModule())))) {
                this.addNamedImport((SymbolTableEntryOriginal)ste, null);
            }
        };
        thingsToImportSTE.forEach(_function_2);
    }

    private void removeUnusedImports() {
        Functions.Function1 _function = it -> {
            boolean _isUsed = this.isUsed((ImportSpecifier)it);
            return !_isUsed;
        };
        List unusedImports = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)this.getState().im, ImportSpecifier.class), (Functions.Function1)_function));
        for (ImportSpecifier is : unusedImports) {
            EObject _eContainer = is.eContainer();
            ImportDeclaration container = (ImportDeclaration)_eContainer;
            Object _xifexpression = null;
            _xifexpression = container.getImportSpecifiers().size() == 1 && container.getImportSpecifiers().contains((Object)is) ? container : is;
            ImportSpecifier toBeRemoved = _xifexpression;
            this.remove((EObject)toBeRemoved);
        }
    }

    private boolean isUsed(ImportSpecifier importSpec) {
        boolean _tripleEquals;
        boolean _isFlaggedUsedInCode = importSpec.isFlaggedUsedInCode();
        boolean bl = _tripleEquals = Boolean.valueOf(_isFlaggedUsedInCode) == Boolean.valueOf(false);
        if (_tripleEquals) {
            return false;
        }
        SymbolTableEntryOriginal _xifexpression = null;
        if (importSpec instanceof NamedImportSpecifier) {
            _xifexpression = this.findSymbolTableEntryForNamedImport((NamedImportSpecifier)importSpec);
        } else {
            SymbolTableEntryOriginal _xifexpression_1 = null;
            if (importSpec instanceof NamespaceImportSpecifier) {
                _xifexpression_1 = this.findSymbolTableEntryForNamespaceImport((NamespaceImportSpecifier)importSpec);
            }
            _xifexpression = _xifexpression_1;
        }
        SymbolTableEntryOriginal ste = _xifexpression;
        Functions.Function1 _function = it -> TranspilerUtils.isIntermediateModelElement((EObject)it);
        boolean hasReference = IterableExtensions.exists((Iterable)ste.getReferencingElements(), (Functions.Function1)_function);
        if (hasReference) {
            IdentifiableElement target = ste.getOriginalTarget();
            return target != null && ScriptDependencyResolver.shouldBeImported((TModule)this.getState().resource.getModule(), (EObject)target);
        }
        return false;
    }
}

