/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;

public class BuildSet {
    final Set<IN4JSProject> requestedProjects;
    final Set<IN4JSProject> discoveredProjects;
    final Predicate<FileURI> resourceFilter;

    public static BuildSet combineDiscovered(BuildSet set1, BuildSet set2) {
        return new BuildSet(set1.requestedProjects, (Collection<IN4JSProject>)Sets.union(set1.discoveredProjects, set2.discoveredProjects), set1.resourceFilter);
    }

    public Set<IN4JSProject> getAllProjects() {
        return Sets.union(this.requestedProjects, this.discoveredProjects);
    }

    BuildSet(Collection<IN4JSProject> requestedProjects, Collection<IN4JSProject> discoveredProjects, Predicate<FileURI> projectFilter) {
        this.requestedProjects = ImmutableSet.copyOf(requestedProjects);
        this.discoveredProjects = ImmutableSet.copyOf(discoveredProjects);
        this.resourceFilter = projectFilter;
    }
}

