/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.utils;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.util.MemberList;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.utils.UtilN4;

public class MemberMatrix {
    static final String[] COLS = new String[]{"owned", "inherited", "implemented"};
    static final int OWNED = 0;
    static final int INHERITED = 1;
    static final int IMPLEMENTED = 2;
    static final int CONSUMED = 3;
    static final int SOURCE_COUNT_WITHOUT_CONSUMED = 3;
    static final int MEMBER_TYPE_COUNT = MemberType.values().length;
    private final Set<TMember> consumed;
    private final MemberList<TMember>[][] memberMatrix = new MemberList[3][MEMBER_TYPE_COUNT];
    private final MemberList<TMember> nonImplemented;

    public MemberMatrix() {
        this.consumed = new HashSet<TMember>(2);
        this.nonImplemented = new MemberList(2);
    }

    public void markConsumed(MemberList<TMember> consumedMembers) {
        this.consumed.addAll((Collection<TMember>)consumedMembers);
    }

    public boolean isConsumed(TMember member) {
        return this.consumed.contains(member);
    }

    public boolean hasOwnedAccessorPair() {
        return !this.members(0, MemberType.GETTER).isEmpty() && !this.members(0, MemberType.SETTER).isEmpty();
    }

    public boolean hasMixedAccessorPair() {
        boolean hasInheritedSetter;
        boolean hasOwnedGetter = !this.members(0, MemberType.GETTER).isEmpty();
        boolean hasOwnedSetter = !this.members(0, MemberType.SETTER).isEmpty();
        boolean hasInheritedGetter = !this.members(1, MemberType.GETTER).isEmpty();
        boolean bl = hasInheritedSetter = !this.members(1, MemberType.SETTER).isEmpty();
        return !hasOwnedGetter && hasInheritedGetter && hasOwnedSetter || hasOwnedGetter && hasInheritedSetter && !hasOwnedSetter;
    }

    public boolean hasAccessorPair() {
        return !(this.members(0, MemberType.GETTER).isEmpty() && this.members(1, MemberType.GETTER).isEmpty() && this.members(2, MemberType.GETTER).isEmpty() || this.members(0, MemberType.SETTER).isEmpty() && this.members(1, MemberType.SETTER).isEmpty() && this.members(2, MemberType.SETTER).isEmpty());
    }

    public SourceAwareIterator allMembers() {
        return new SourceAwareIterator(false);
    }

    public ActuallyInheritedAndConsumedMembersIterator actuallyInheritedAndMixedMembers() {
        return new ActuallyInheritedAndConsumedMembersIterator();
    }

    public SourceAwareIterator ownedConsumedInheritedImplemented() {
        return new SourceAwareIterator(true);
    }

    private <T extends TMember> MemberList<T> members(int source, MemberType type) {
        MemberList<TMember> list = this.memberMatrix[source][type.getValue()];
        if (list == null) {
            return MemberList.emptyList();
        }
        return list;
    }

    private boolean hasOwnedOrNotAbstractMember(int source, MemberType type) {
        MemberList list = this.members(source, type);
        if (list.isEmpty()) {
            return false;
        }
        if (source == 0) {
            return true;
        }
        return list.stream().anyMatch(m -> !m.isAbstract());
    }

    public Iterable<TMember> owned() {
        return this.members(0);
    }

    public Iterable<TMember> inherited() {
        return this.members(1);
    }

    public Iterable<TMember> implemented() {
        return this.members(2);
    }

    private Iterable<TMember> members(int source) {
        return this.hasSource(source) ? Iterables.concat(this.members(source, MemberType.GETTER), this.members(source, MemberType.SETTER), this.members(source, MemberType.FIELD), this.members(source, MemberType.METHOD)) : MemberList.emptyList();
    }

    public Iterable<TMember> nonImplemented() {
        return this.nonImplemented;
    }

    public boolean hasOwned() {
        return this.hasSource(0);
    }

    public boolean hasInherited() {
        return this.hasSource(1);
    }

    public boolean hasImplemented() {
        return this.hasSource(2);
    }

    public boolean hasNonImplemented() {
        return !this.nonImplemented.isEmpty();
    }

    private boolean hasSource(int source) {
        int i = 0;
        while (i < MEMBER_TYPE_COUNT) {
            if (this.memberMatrix[source][i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isActuallyInherited(TMember m) {
        if (this.hasOwned()) {
            if (m.getMemberType() == MemberType.GETTER) {
                if (this.hasOwnedOrNotAbstractMember(0, MemberType.FIELD) || this.hasOwnedOrNotAbstractMember(0, MemberType.GETTER) || this.hasOwnedOrNotAbstractMember(0, MemberType.METHOD)) {
                    return false;
                }
            } else if (m.getMemberType() == MemberType.SETTER) {
                if (this.hasOwnedOrNotAbstractMember(0, MemberType.FIELD) || this.hasOwnedOrNotAbstractMember(0, MemberType.SETTER) || this.hasOwnedOrNotAbstractMember(0, MemberType.METHOD)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (m.isField() || !m.isAbstract()) {
            return true;
        }
        if (this.hasImplemented()) {
            if (m.getMemberType() == MemberType.GETTER) {
                if (this.hasOwnedOrNotAbstractMember(2, MemberType.FIELD) || this.hasOwnedOrNotAbstractMember(2, MemberType.GETTER) || this.hasOwnedOrNotAbstractMember(2, MemberType.METHOD)) {
                    return false;
                }
            } else if (m.getMemberType() == MemberType.SETTER) {
                if (this.hasOwnedOrNotAbstractMember(2, MemberType.FIELD) || this.hasOwnedOrNotAbstractMember(2, MemberType.SETTER) || this.hasOwnedOrNotAbstractMember(2, MemberType.METHOD)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public void add(int source, TMember member) {
        if (source == 2 && member.isStatic() && member.getContainingType() instanceof TInterface) {
            this.nonImplemented.add((Object)member);
            return;
        }
        int row = member.getMemberType().getValue();
        MemberList list = this.memberMatrix[source][row];
        if (list == null) {
            this.memberMatrix[source][row] = list = new MemberList();
        }
        list.add((Object)member);
    }

    public String toString() {
        if (!this.allMembers().hasNext()) {
            return "MemberMatrix not initialized yet.";
        }
        TMember first = this.allMembers().next();
        StringBuilder strb = new StringBuilder("MemberMatrix: ");
        if (first.isStatic()) {
            strb.append("static ");
        }
        strb.append(first.getName());
        strb.append("\n");
        int tab = 15;
        StringBuilder row = new StringBuilder();
        this.tab(row, 10);
        int source = 0;
        while (source < 3) {
            row.append(COLS[source]);
            if (source < 2) {
                this.tab(row, 10 + (1 + source) * 15);
            }
            ++source;
        }
        strb.append((CharSequence)row);
        MemberType[] memberTypeArray = MemberType.values();
        int n = memberTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemberType type = memberTypeArray[n2];
            row.setLength(0);
            row.append(type.getName()).append(": ");
            this.tab(row, 10);
            int source2 = 0;
            while (source2 < 3) {
                row.append(this.members(source2, type).stream().map(m -> m.getContainingType().getName()).collect(Collectors.joining(",")));
                if (source2 < 2) {
                    this.tab(row, 10 + (1 + source2) * 15);
                }
                ++source2;
            }
            strb.append("\n").append((CharSequence)row);
            ++n2;
        }
        strb.append("\n");
        if (!this.consumed.isEmpty()) {
            strb.append("consumed: ");
            strb.append(this.consumed.stream().map(m -> m != null ? m.getMemberType() + " " + m.getContainingType().getName() + "." + m.getName() : "null").collect(Collectors.joining(",")));
        }
        return strb.toString();
    }

    private void tab(StringBuilder strb, int offset) {
        UtilN4.fill((StringBuilder)strb, (int)offset);
        strb.append('|');
    }

    String toShortString() {
        if (!this.allMembers().hasNext()) {
            return "MemberMatrix not initialized yet.";
        }
        StringBuilder strb = new StringBuilder("[");
        MemberType[] memberTypeArray = MemberType.values();
        int n = memberTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemberType type = memberTypeArray[n2];
            int source = 0;
            while (source < 3) {
                strb.append(this.members(source, type).stream().map(m -> String.valueOf(m.getMemberType().getName().charAt(0)) + " " + m.getContainingType().getName()).collect(Collectors.joining(",")));
                ++source;
            }
            ++n2;
        }
        if (!this.consumed.isEmpty()) {
            strb.append(", consumed: ");
            strb.append(this.consumed.stream().map(m -> m != null ? String.valueOf(m.getMemberType().getName().charAt(0)) + " " + m.getContainingType().getName() : "null").collect(Collectors.joining(",")));
        }
        strb.append("]");
        return strb.toString();
    }

    public TMember possibleOverrideCandidateOrError(TMember member) {
        TMember result = null;
        for (TMember m : Iterables.concat(this.implemented(), this.inherited())) {
            if (TypeUtils.isAccessorPair((TMember)member, (TMember)m)) continue;
            if (m.getMemberAccessModifier() == MemberAccessModifier.PRIVATE) {
                result = m;
                continue;
            }
            return m;
        }
        return result;
    }

    public class ActuallyInheritedAndConsumedMembersIterator
    extends SourceAwareIterator {
        ActuallyInheritedAndConsumedMembersIterator() {
            super(true);
        }

        @Override
        protected void initIter() {
            this.source = 3;
            this.currentIter = MemberMatrix.this.consumed.iterator();
        }

        @Override
        protected TMember findNext() {
            while (true) {
                if (this.currentIter.hasNext()) {
                    TMember m = (TMember)this.currentIter.next();
                    if (this.source != 3 && !MemberMatrix.this.isActuallyInherited(m)) continue;
                    return m;
                }
                this.currentIter = this.nextIter();
                if (this.source < 0) break;
            }
            return null;
        }

        @Override
        protected Iterator<TMember> nextIter() {
            switch (this.source) {
                case 3: {
                    this.source = 1;
                    return MemberMatrix.this.members(this.source).iterator();
                }
            }
            this.source = -1;
            return null;
        }
    }

    public class SourceAwareIterator
    implements Iterator<TMember> {
        private int lastRetrievedSource = -1;
        private TMember lastRetrievedElement;
        protected int source;
        protected Iterator<TMember> currentIter;
        private TMember next;
        private final boolean returnConsumed;

        SourceAwareIterator(boolean returnConsumed) {
            this.returnConsumed = returnConsumed;
            this.initIter();
            this.next = this.findNext();
        }

        protected void initIter() {
            this.source = 0;
            this.currentIter = MemberMatrix.this.members(this.source).iterator();
        }

        public boolean isActualMember() {
            return this.lastRetrievedSource == 0 || this.lastRetrievedSource == 3 || this.lastRetrievedSource == 1 && MemberMatrix.this.isActuallyInherited(this.lastRetrievedElement);
        }

        public boolean isInterfaceMember() {
            return this.lastRetrievedSource == 2;
        }

        public boolean isInheritedMember() {
            return this.lastRetrievedSource == 1;
        }

        public boolean isOwnedMember() {
            return this.lastRetrievedSource == 0;
        }

        protected TMember findNext() {
            while (true) {
                if (this.currentIter.hasNext()) {
                    TMember m = this.currentIter.next();
                    if (this.returnConsumed && this.source == 2 && MemberMatrix.this.consumed.contains(m)) continue;
                    return m;
                }
                this.currentIter = this.nextIter();
                if (this.source < 0) break;
            }
            return null;
        }

        protected Iterator<TMember> nextIter() {
            switch (this.source) {
                case 0: {
                    if (this.returnConsumed) {
                        this.source = 3;
                        return MemberMatrix.this.consumed.iterator();
                    }
                }
                case 3: {
                    this.source = 1;
                    return MemberMatrix.this.members(this.source).iterator();
                }
                case 1: {
                    this.source = 2;
                    return MemberMatrix.this.members(this.source).iterator();
                }
            }
            this.source = -1;
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.source >= 0;
        }

        @Override
        public TMember next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRetrievedElement = this.next;
            this.lastRetrievedSource = this.source;
            this.next = this.findNext();
            return this.lastRetrievedElement;
        }
    }
}

