/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.util;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.registry.ILanguageInfo;
import org.eclipse.xpect.runner.XpectRunner;
import org.eclipse.xtext.resource.ClassloaderClasspathUriResolver;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceFactory;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.StringInputStream;
import org.osgi.framework.Bundle;

public class XpectFileAccess {
    public static ClassLoader getXpectLibClassLoader() {
        Bundle lib = Platform.getBundle((String)"org.eclipse.xpect.xtext.lib");
        if (lib != null) {
            try {
                Class cls = lib.loadClass("org.eclipse.xpect.xtext.lib.tests.XtextTests");
                ClassLoader loader = cls.getClassLoader();
                return loader;
            }
            catch (ClassNotFoundException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    protected static ResourceSet cloneResourceSet(ResourceSet rs) {
        XtextResourceSet result = new XtextResourceSet();
        result.setPackageRegistry(rs.getPackageRegistry());
        result.setURIConverter(rs.getURIConverter());
        if (XpectRunner.testClassloader != null) {
            result.setClasspathURIContext((Object)XpectRunner.testClassloader);
            result.setClasspathUriResolver((IClasspathUriResolver)new ClassloaderClasspathUriResolver());
        } else if (rs instanceof XtextResourceSet) {
            XtextResourceSet xrs = (XtextResourceSet)rs;
            Object context = xrs.getClasspathURIContext();
            if (context != null) {
                result.setClasspathURIContext(context);
                result.setClasspathUriResolver(xrs.getClasspathUriResolver());
            } else {
                result.setClasspathURIContext((Object)XpectFileAccess.getXpectLibClassLoader());
                result.setClasspathUriResolver((IClasspathUriResolver)new ClassloaderClasspathUriResolver());
            }
        }
        return result;
    }

    private static XpectFile findXpectFile(Resource xpectResource) {
        for (EObject contents : xpectResource.getContents()) {
            if (!(contents instanceof XpectFile)) continue;
            return (XpectFile)contents;
        }
        return null;
    }

    public static XpectFile getXpectFile(Resource resource) {
        for (EObject contents : resource.getContents()) {
            if (!(contents instanceof XpectFile)) continue;
            return (XpectFile)contents;
        }
        return XpectFileAccess.findXpectFile((Resource)XpectFileAccess.getXpectResource(resource));
    }

    public static XtextResource getXpectResource(Resource resource) {
        for (EObject contents : resource.getContents()) {
            if (!(contents instanceof XpectFile)) continue;
            return (XtextResource)resource;
        }
        String document = ((XtextResource)resource).getParseResult().getRootNode().getText();
        for (Adapter a : resource.eAdapters()) {
            if (!(a instanceof XpectResourceAdapter)) continue;
            XtextResource xpectResource = ((XpectResourceAdapter)a).resource;
            if (!xpectResource.getParseResult().getRootNode().getText().equals(document)) {
                XpectFileAccess.load((Resource)xpectResource, document);
            }
            return xpectResource;
        }
        ResourceSet rs = XpectFileAccess.cloneResourceSet(resource.getResourceSet());
        Injector injector = ILanguageInfo.Registry.INSTANCE.getLanguageByFileExtension("xpect").getInjector();
        XtextResource xpectResource = (XtextResource)((XtextResourceFactory)injector.getInstance(XtextResourceFactory.class)).createResource(resource.getURI());
        rs.getResources().add((Object)xpectResource);
        XpectFileAccess.load((Resource)xpectResource, document);
        resource.eAdapters().add((Object)new XpectResourceAdapter(xpectResource));
        return xpectResource;
    }

    private static void load(Resource xpectResource, String document) {
        try {
            xpectResource.unload();
            xpectResource.load((InputStream)new StringInputStream(document), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class XpectResourceAdapter
    extends AdapterImpl {
        private final XtextResource resource;

        public XpectResourceAdapter(XtextResource resource) {
            this.resource = resource;
        }
    }
}

